/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.rx.codec.CodecUtil;
import org.rx.core.Arrays;
import org.rx.exception.TraceHandler;
import org.rx.net.SocketConfig;
import org.rx.net.Sockets;
import org.rx.net.shadowsocks.SSCommon;
import org.rx.net.shadowsocks.ShadowsocksServer;
import org.rx.net.socks.BackendRelayHandler;
import org.rx.net.socks.FrontendRelayHandler;
import org.rx.net.socks.SocksContext;
import org.rx.net.support.SocksSupport;
import org.rx.net.support.UnresolvedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ServerTcpProxyHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ServerTcpProxyHandler.class);
    public static final ServerTcpProxyHandler DEFAULT = new ServerTcpProxyHandler();

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel inbound = ctx.channel();
        ShadowsocksServer server = SocksContext.ssServer(inbound, true);
        InetSocketAddress realEp = (InetSocketAddress)inbound.attr(SSCommon.REMOTE_DEST).get();
        SocksContext e = new SocksContext((InetSocketAddress)inbound.remoteAddress(), new UnresolvedEndpoint(realEp));
        server.raiseEvent(server.onRoute, e);
        UnresolvedEndpoint dstEp = e.getUpstream().getDestination();
        if (SocksSupport.FAKE_IPS.contains(dstEp.getHost()) || !Sockets.isValidIp(dstEp.getHost())) {
            BigInteger hash = CodecUtil.hashUnsigned64(dstEp.toString().getBytes(StandardCharsets.UTF_8));
            SocksSupport.fakeDict().putIfAbsent(hash, dstEp);
            dstEp = new UnresolvedEndpoint(String.format("%s%s", hash, "x.f-li.cn"), Arrays.randomNext(SocksSupport.FAKE_PORT_OBFS));
        }
        UnresolvedEndpoint finalDestinationEp = dstEp;
        Sockets.bootstrap((EventLoopGroup)inbound.eventLoop(), (SocketConfig)server.config, outbound -> {
            e.getUpstream().initChannel((Channel)outbound);
            SocksContext.mark(inbound, (Channel)outbound, e, true);
            inbound.pipeline().addLast(new ChannelHandler[]{FrontendRelayHandler.DEFAULT});
        }).connect((SocketAddress)dstEp.socketAddress()).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                TraceHandler.INSTANCE.log("connect to backend {}[{}] fail", finalDestinationEp, realEp, f.cause());
                Sockets.closeOnFlushed(inbound);
                return;
            }
            log.debug("connect to backend {}[{}]", (Object)finalDestinationEp, (Object)realEp);
            Channel outbound = f.channel();
            outbound.pipeline().addLast(new ChannelHandler[]{BackendRelayHandler.DEFAULT});
            SocksSupport.ENDPOINT_TRACER.link(inbound, outbound);
        }));
        ctx.fireChannelRead(msg).pipeline().remove((ChannelHandler)this);
    }
}

