/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import org.rx.net.AuthenticEndpoint;
import org.rx.net.Sockets;
import org.rx.net.shadowsocks.SSCommon;
import org.rx.net.shadowsocks.ShadowsocksServer;
import org.rx.net.socks.ProxyChannelIdleHandler;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.UdpManager;
import org.rx.net.socks.upstream.Upstream;
import org.rx.net.support.UnresolvedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ServerUdpProxyHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(ServerUdpProxyHandler.class);
    public static final ServerUdpProxyHandler DEFAULT = new ServerUdpProxyHandler();

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf inBuf) throws Exception {
        Channel inbound = ctx.channel();
        InetSocketAddress srcEp = (InetSocketAddress)inbound.attr(SSCommon.REMOTE_ADDRESS).get();
        UnresolvedEndpoint dstEp = new UnresolvedEndpoint((InetSocketAddress)inbound.attr(SSCommon.REMOTE_DEST).get());
        ShadowsocksServer server = SocksContext.ssServer(inbound, true);
        Channel outbound = UdpManager.openChannel(srcEp, k -> {
            SocksContext e = new SocksContext(srcEp, dstEp);
            server.raiseEvent(server.onUdpRoute, e);
            Upstream upstream = e.getUpstream();
            return Sockets.udpBootstrap(server.config.getMemoryMode(), ob -> {
                SocksContext.ssServer((Channel)ob, server);
                e.onClose = () -> UdpManager.closeChannel(srcEp);
                SocksContext.mark(inbound, (Channel)ob, e, false);
                upstream.initChannel((Channel)ob);
                ob.pipeline().addLast(new ChannelHandler[]{new ProxyChannelIdleHandler(server.config.getUdpTimeoutSeconds(), 0), UdpBackendRelayHandler.DEFAULT});
            }).bind(0).syncUninterruptibly().channel();
        });
        SocksContext sc = SocksContext.ctx(outbound);
        UnresolvedEndpoint upDstEp = sc.getUpstream().getDestination();
        AuthenticEndpoint upSvrEp = sc.getUpstream().getSocksServer();
        if (upSvrEp != null) {
            inBuf = UdpManager.socks5Encode(inBuf, dstEp);
            upDstEp = new UnresolvedEndpoint(upSvrEp.getEndpoint());
        } else {
            inBuf.retain();
        }
        UdpManager.pendOrWritePacket(outbound, new DatagramPacket(inBuf, upDstEp.socketAddress()));
    }

    @ChannelHandler.Sharable
    public static class UdpBackendRelayHandler
    extends SimpleChannelInboundHandler<DatagramPacket> {
        private static final Logger log = LoggerFactory.getLogger(UdpBackendRelayHandler.class);
        public static final UdpBackendRelayHandler DEFAULT = new UdpBackendRelayHandler();

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket out) throws Exception {
            Channel outbound = ctx.channel();
            SocksContext sc = SocksContext.ctx(outbound);
            UnresolvedEndpoint dstEp = sc.getFirstDestination();
            ByteBuf outBuf = (ByteBuf)out.content();
            if (sc.getUpstream().getSocksServer() != null) {
                UnresolvedEndpoint tmp = UdpManager.socks5Decode(outBuf);
                if (!dstEp.equals(tmp)) {
                    log.error("UDP SOCKS ERROR {} != {}", (Object)dstEp, (Object)tmp);
                }
                sc.inbound.attr(SSCommon.REMOTE_SRC).set((Object)tmp.socketAddress());
            } else {
                sc.inbound.attr(SSCommon.REMOTE_SRC).set((Object)((InetSocketAddress)out.sender()));
            }
            sc.inbound.writeAndFlush((Object)outBuf.retain());
        }
    }
}

