/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import lombok.NonNull;
import org.rx.core.Delegate;
import org.rx.core.Disposable;
import org.rx.core.EventPublisher;
import org.rx.net.MemoryMode;
import org.rx.net.Sockets;
import org.rx.net.shadowsocks.CipherCodec;
import org.rx.net.shadowsocks.ProtocolCodec;
import org.rx.net.shadowsocks.SSCommon;
import org.rx.net.shadowsocks.ServerReceiveHandler;
import org.rx.net.shadowsocks.ServerSendHandler;
import org.rx.net.shadowsocks.ServerTcpProxyHandler;
import org.rx.net.shadowsocks.ServerUdpProxyHandler;
import org.rx.net.shadowsocks.ShadowsocksConfig;
import org.rx.net.shadowsocks.encryption.CryptoFactory;
import org.rx.net.shadowsocks.encryption.ICrypto;
import org.rx.net.socks.ProxyChannelIdleHandler;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.upstream.Upstream;
import org.rx.util.function.TripleAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowsocksServer
extends Disposable
implements EventPublisher<ShadowsocksServer> {
    private static final Logger log = LoggerFactory.getLogger(ShadowsocksServer.class);
    public static final TripleAction<ShadowsocksServer, SocksContext> DIRECT_ROUTER = (s, e) -> e.setUpstream(new Upstream(e.getFirstDestination()));
    public final Delegate<ShadowsocksServer, SocksContext> onRoute = Delegate.create(DIRECT_ROUTER);
    public final Delegate<ShadowsocksServer, SocksContext> onUdpRoute = Delegate.create(DIRECT_ROUTER);
    final ShadowsocksConfig config;
    final ServerBootstrap bootstrap;
    final Channel udpChannel;

    public ShadowsocksServer(@NonNull ShadowsocksConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.bootstrap = Sockets.serverBootstrap(this.config, channel -> {
            channel.attr(SSCommon.IS_UDP).set((Object)false);
            ICrypto _crypto = CryptoFactory.get(config.getMethod(), config.getPassword());
            _crypto.setForUdp(false);
            channel.attr(SSCommon.CIPHER).set((Object)_crypto);
            channel.pipeline().addLast(new ChannelHandler[]{new ProxyChannelIdleHandler(config.getTcpTimeoutSeconds(), 0)});
            SocksContext.ssServer((Channel)channel, this);
            channel.pipeline().addLast(new ChannelHandler[]{ServerReceiveHandler.DEFAULT, ServerSendHandler.DEFAULT, CipherCodec.DEFAULT, new ProtocolCodec(), ServerTcpProxyHandler.DEFAULT});
        });
        this.bootstrap.bind((SocketAddress)config.getServerEndpoint()).addListener((GenericFutureListener)Sockets.logBind(config.getServerEndpoint().getPort()));
        this.udpChannel = Sockets.udpBootstrap("SS", MemoryMode.HIGH, ctx -> {
            ctx.attr(SSCommon.IS_UDP).set((Object)true);
            ICrypto _crypto = CryptoFactory.get(config.getMethod(), config.getPassword());
            _crypto.setForUdp(true);
            ctx.attr(SSCommon.CIPHER).set((Object)_crypto);
            SocksContext.ssServer((Channel)ctx, this);
            ctx.pipeline().addLast(new ChannelHandler[]{ServerReceiveHandler.DEFAULT, ServerSendHandler.DEFAULT, CipherCodec.DEFAULT, new ProtocolCodec(), ServerUdpProxyHandler.DEFAULT});
        }).bind((SocketAddress)config.getServerEndpoint()).addListener((GenericFutureListener)Sockets.logBind(config.getServerEndpoint().getPort())).channel();
    }

    @Override
    protected void freeObjects() {
        Sockets.closeBootstrap(this.bootstrap);
        this.udpChannel.close();
    }
}

