/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.encryption;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.rx.io.Bytes;
import org.rx.net.shadowsocks.encryption.ICrypto;
import org.rx.net.shadowsocks.encryption.ShadowSocksKey;

public abstract class CryptoAeadBase
implements ICrypto {
    protected static int PAYLOAD_SIZE_MASK = 16383;
    private static final byte[] info = "ss-subkey".getBytes();
    private static final byte[] ZERO_NONCE = new byte[CryptoAeadBase.getNonceLength()];
    protected final String _name;
    protected final ShadowSocksKey _ssKey;
    protected final int _keyLength;
    private boolean forUdp;
    protected boolean _encryptSaltSet;
    protected boolean _decryptSaltSet;
    protected final Object encLock = new Object();
    protected final Object decLock = new Object();
    protected AEADCipher encCipher;
    protected AEADCipher decCipher;
    private byte[] encSubkey;
    private byte[] decSubkey;
    protected byte[] encNonce;
    protected byte[] decNonce;
    protected byte[] encBuffer = new byte[2 + CryptoAeadBase.getTagLength() + PAYLOAD_SIZE_MASK + CryptoAeadBase.getTagLength()];
    protected byte[] decBuffer = new byte[PAYLOAD_SIZE_MASK + CryptoAeadBase.getTagLength()];
    protected int payloadLenRead = 0;
    protected int payloadRead = 0;

    private static int getNonceLength() {
        return 12;
    }

    protected static int getTagLength() {
        return 16;
    }

    protected static void increment(byte[] nonce) {
        for (int i = 0; i < nonce.length; ++i) {
            int n = i;
            nonce[n] = (byte)(nonce[n] + 1);
            if (nonce[i] != 0) break;
        }
    }

    public CryptoAeadBase(String name, String password) {
        this._name = name.toLowerCase();
        this._keyLength = this.getKeyLength();
        this._ssKey = new ShadowSocksKey(password, this._keyLength);
    }

    @Override
    public void setForUdp(boolean forUdp) {
        this.forUdp = forUdp;
        if (!forUdp && this.encNonce == null && this.decNonce == null) {
            this.encNonce = new byte[CryptoAeadBase.getNonceLength()];
            this.decNonce = new byte[CryptoAeadBase.getNonceLength()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(byte[] data, ByteBuf stream) {
        Object object = this.encLock;
        synchronized (object) {
            stream.clear();
            if (!this._encryptSaltSet || this.forUdp) {
                byte[] salt = Bytes.randomBytes(this.getSaltLength());
                stream.writeBytes(salt);
                this.encSubkey = this.genSubkey(salt);
                this.encCipher = this.getCipher(true);
                this._encryptSaltSet = true;
            }
            if (!this.forUdp) {
                this._tcpEncrypt(data, stream);
            } else {
                this._udpEncrypt(data, stream);
            }
        }
    }

    @Override
    public void encrypt(byte[] data, int length, ByteBuf stream) {
        byte[] d = Arrays.copyOfRange(data, 0, length);
        this.encrypt(d, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(byte[] data, ByteBuf stream) {
        Object object = this.decLock;
        synchronized (object) {
            byte[] temp;
            stream.clear();
            ByteBuffer buffer = ByteBuffer.wrap(data);
            if (this.decCipher == null || this.forUdp) {
                this._decryptSaltSet = true;
                byte[] salt = new byte[this.getSaltLength()];
                buffer.get(salt);
                this.decSubkey = this.genSubkey(salt);
                this.decCipher = this.getCipher(false);
                temp = new byte[buffer.remaining()];
                buffer.get(temp);
            } else {
                temp = data;
            }
            if (!this.forUdp) {
                this._tcpDecrypt(temp, stream);
            } else {
                this._udpDecrypt(temp, stream);
            }
        }
    }

    @Override
    public void decrypt(byte[] data, int length, ByteBuf stream) {
        byte[] d = Arrays.copyOfRange(data, 0, length);
        this.decrypt(d, stream);
    }

    private byte[] genSubkey(byte[] salt) {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA1Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(this._ssKey.getEncoded(), salt, info));
        byte[] okm = new byte[this.getKeyLength()];
        hkdf.generateBytes(okm, 0, this.getKeyLength());
        return okm;
    }

    protected CipherParameters getCipherParameters(boolean forEncryption) {
        byte[] nonce = !this.forUdp ? (forEncryption ? Arrays.copyOf(this.encNonce, CryptoAeadBase.getNonceLength()) : Arrays.copyOf(this.decNonce, CryptoAeadBase.getNonceLength())) : ZERO_NONCE;
        return new AEADParameters(new KeyParameter(forEncryption ? this.encSubkey : this.decSubkey), CryptoAeadBase.getTagLength() * 8, nonce);
    }

    protected abstract int getKeyLength();

    protected abstract int getSaltLength();

    protected abstract AEADCipher getCipher(boolean var1);

    protected abstract void _tcpEncrypt(byte[] var1, ByteBuf var2);

    protected abstract void _tcpDecrypt(byte[] var1, ByteBuf var2);

    protected abstract void _udpEncrypt(byte[] var1, ByteBuf var2);

    protected abstract void _udpDecrypt(byte[] var1, ByteBuf var2);
}

