/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.encryption;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.rx.io.Bytes;
import org.rx.net.shadowsocks.encryption.ICrypto;
import org.rx.net.shadowsocks.encryption.ShadowSocksKey;

public abstract class CryptoSteamBase
implements ICrypto {
    protected final String _name;
    protected final SecretKey _key;
    protected final ShadowSocksKey _ssKey;
    protected final int _ivLength;
    protected final int _keyLength;
    protected boolean forUdp;
    protected boolean _encryptIVSet;
    protected boolean _decryptIVSet;
    protected byte[] _encryptIV;
    protected byte[] _decryptIV;
    protected final Object encLock = new Object();
    protected final Object decLock = new Object();
    protected StreamCipher encCipher;
    protected StreamCipher decCipher;

    public CryptoSteamBase(String name, String password) {
        this._name = name.toLowerCase();
        this._ivLength = this.getIVLength();
        this._keyLength = this.getKeyLength();
        this._ssKey = new ShadowSocksKey(password, this._keyLength);
        this._key = this.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(byte[] data, ByteBuf stream) {
        Object object = this.encLock;
        synchronized (object) {
            stream.clear();
            if (!this._encryptIVSet || this.forUdp) {
                this._encryptIVSet = true;
                byte[] iv = Bytes.randomBytes(this._ivLength);
                this.setIV(iv, true);
                stream.writeBytes(iv);
            }
            this._encrypt(data, stream);
        }
    }

    @Override
    public void encrypt(byte[] data, int length, ByteBuf stream) {
        byte[] d = Arrays.copyOfRange(data, 0, length);
        this.encrypt(d, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(byte[] data, ByteBuf stream) {
        Object object = this.decLock;
        synchronized (object) {
            byte[] temp;
            stream.clear();
            if (!this._decryptIVSet || this.forUdp) {
                this._decryptIVSet = true;
                this.setIV(data, false);
                temp = Arrays.copyOfRange(data, this._ivLength, data.length);
            } else {
                temp = data;
            }
            this._decrypt(temp, stream);
        }
    }

    @Override
    public void decrypt(byte[] data, int length, ByteBuf stream) {
        byte[] d = Arrays.copyOfRange(data, 0, length);
        this.decrypt(d, stream);
    }

    protected void setIV(byte[] iv, boolean isEncrypt) {
        if (this._ivLength == 0) {
            return;
        }
        if (isEncrypt) {
            CipherParameters cipherParameters = this.getCipherParameters(iv);
            this.encCipher = this.getCipher(isEncrypt);
            this.encCipher.init(isEncrypt, cipherParameters);
        } else {
            this._decryptIV = Arrays.copyOfRange(iv, 0, this._ivLength);
            CipherParameters cipherParameters = this.getCipherParameters(iv);
            this.decCipher = this.getCipher(isEncrypt);
            this.decCipher.init(isEncrypt, cipherParameters);
        }
    }

    protected CipherParameters getCipherParameters(byte[] iv) {
        this._decryptIV = Arrays.copyOfRange(iv, 0, this._ivLength);
        return new ParametersWithIV((CipherParameters)new KeyParameter(this._key.getEncoded()), this._decryptIV);
    }

    protected abstract int getIVLength();

    protected abstract int getKeyLength();

    protected abstract SecretKey getKey();

    protected abstract StreamCipher getCipher(boolean var1);

    protected abstract void _encrypt(byte[] var1, ByteBuf var2);

    protected abstract void _decrypt(byte[] var1, ByteBuf var2);

    @Override
    public void setForUdp(boolean forUdp) {
        this.forUdp = forUdp;
    }
}

