/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.encryption;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowSocksKey
implements SecretKey {
    private static final Logger log = LoggerFactory.getLogger(ShadowSocksKey.class);
    private static final long serialVersionUID = 1L;
    private static final int KEY_LENGTH = 32;
    private final byte[] _key;
    private final int _length;

    public ShadowSocksKey(String password) {
        this._length = 32;
        this._key = this.init(password);
    }

    public ShadowSocksKey(String password, int length) {
        this._length = length;
        this._key = this.init(password);
    }

    private byte[] init(String password) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] keys = new byte[32];
        byte[] temp = null;
        byte[] hash = null;
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < keys.length; i += hash.length) {
            if (i == 0) {
                hash = md.digest(passwordBytes);
                temp = new byte[passwordBytes.length + hash.length];
            } else {
                System.arraycopy(hash, 0, temp, 0, hash.length);
                System.arraycopy(passwordBytes, 0, temp, hash.length, passwordBytes.length);
                hash = md.digest(temp);
            }
            System.arraycopy(hash, 0, keys, i, hash.length);
        }
        if (this._length != 32) {
            byte[] keysl = new byte[this._length];
            System.arraycopy(keys, 0, keysl, 0, this._length);
            return keysl;
        }
        return keys;
    }

    @Override
    public String getAlgorithm() {
        return "shadowsocks";
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        return this._key;
    }
}

