/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.encryption.impl;

import io.netty.buffer.ByteBuf;
import java.security.InvalidAlgorithmParameterException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.StreamBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.rx.net.shadowsocks.encryption.CryptoSteamBase;

public class AesCrypto
extends CryptoSteamBase {
    public static final String CIPHER_AES_128_CFB = "aes-128-cfb";
    public static final String CIPHER_AES_192_CFB = "aes-192-cfb";
    public static final String CIPHER_AES_256_CFB = "aes-256-cfb";
    public static final String CIPHER_AES_128_OFB = "aes-128-ofb";
    public static final String CIPHER_AES_192_OFB = "aes-192-ofb";
    public static final String CIPHER_AES_256_OFB = "aes-256-ofb";

    public AesCrypto(String name, String password) {
        super(name, password);
    }

    @Override
    public int getIVLength() {
        return 16;
    }

    @Override
    public int getKeyLength() {
        switch (this._name) {
            case "aes-128-cfb": 
            case "aes-128-ofb": {
                return 16;
            }
            case "aes-192-cfb": 
            case "aes-192-ofb": {
                return 24;
            }
            case "aes-256-cfb": 
            case "aes-256-ofb": {
                return 32;
            }
        }
        return 0;
    }

    @Override
    protected SecretKey getKey() {
        return new SecretKeySpec(this._ssKey.getEncoded(), "AES");
    }

    protected StreamBlockCipher getCipher(boolean isEncrypted) {
        CFBBlockCipher cipher;
        AESEngine engine = new AESEngine();
        switch (this._name) {
            case "aes-128-cfb": {
                cipher = new CFBBlockCipher((BlockCipher)engine, this.getIVLength() * 8);
                break;
            }
            case "aes-192-cfb": {
                cipher = new CFBBlockCipher((BlockCipher)engine, this.getIVLength() * 8);
                break;
            }
            case "aes-256-cfb": {
                cipher = new CFBBlockCipher((BlockCipher)engine, this.getIVLength() * 8);
                break;
            }
            case "aes-128-ofb": {
                cipher = new OFBBlockCipher((BlockCipher)engine, this.getIVLength() * 8);
                break;
            }
            case "aes-192-ofb": {
                cipher = new OFBBlockCipher((BlockCipher)engine, this.getIVLength() * 8);
                break;
            }
            case "aes-256-ofb": {
                cipher = new OFBBlockCipher((BlockCipher)engine, this.getIVLength() * 8);
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException(this._name);
            }
        }
        return cipher;
    }

    @Override
    protected void _encrypt(byte[] data, ByteBuf stream) {
        byte[] buffer = new byte[data.length];
        int noBytesProcessed = this.encCipher.processBytes(data, 0, data.length, buffer, 0);
        stream.writeBytes(buffer, 0, noBytesProcessed);
    }

    @Override
    protected void _decrypt(byte[] data, ByteBuf stream) {
        byte[] buffer = new byte[data.length];
        int noBytesProcessed = this.decCipher.processBytes(data, 0, data.length, buffer, 0);
        stream.writeBytes(buffer, 0, noBytesProcessed);
    }
}

