/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.encryption.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.rx.net.shadowsocks.encryption.CryptoAeadBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesGcmCrypto
extends CryptoAeadBase {
    private static final Logger log = LoggerFactory.getLogger(AesGcmCrypto.class);
    public static final String AEAD_AES_128_GCM = "aes-128-gcm";
    public static final String AEAD_AES_256_GCM = "aes-256-gcm";

    public AesGcmCrypto(String name, String password) {
        super(name, password);
    }

    @Override
    public int getKeyLength() {
        switch (this._name) {
            case "aes-128-gcm": {
                return 16;
            }
            case "aes-256-gcm": {
                return 32;
            }
        }
        return 0;
    }

    @Override
    public int getSaltLength() {
        switch (this._name) {
            case "aes-128-gcm": {
                return 16;
            }
            case "aes-256-gcm": {
                return 32;
            }
        }
        return 0;
    }

    @Override
    protected AEADCipher getCipher(boolean isEncrypted) {
        switch (this._name) {
            case "aes-128-gcm": 
            case "aes-256-gcm": {
                return new GCMBlockCipher((BlockCipher)new AESEngine());
            }
        }
        throw new InvalidAlgorithmParameterException(this._name);
    }

    @Override
    protected void _tcpEncrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        while (buffer.hasRemaining()) {
            int nr = Math.min(buffer.remaining(), PAYLOAD_SIZE_MASK);
            ByteBuffer.wrap(this.encBuffer).putShort((short)nr);
            this.encCipher.init(true, this.getCipherParameters(true));
            this.encCipher.doFinal(this.encBuffer, this.encCipher.processBytes(this.encBuffer, 0, 2, this.encBuffer, 0));
            stream.writeBytes(this.encBuffer, 0, 2 + AesGcmCrypto.getTagLength());
            AesGcmCrypto.increment(this.encNonce);
            buffer.get(this.encBuffer, 2 + AesGcmCrypto.getTagLength(), nr);
            this.encCipher.init(true, this.getCipherParameters(true));
            this.encCipher.doFinal(this.encBuffer, 2 + AesGcmCrypto.getTagLength() + this.encCipher.processBytes(this.encBuffer, 2 + AesGcmCrypto.getTagLength(), nr, this.encBuffer, 2 + AesGcmCrypto.getTagLength()));
            AesGcmCrypto.increment(this.encNonce);
            stream.writeBytes(this.encBuffer, 2 + AesGcmCrypto.getTagLength(), nr + AesGcmCrypto.getTagLength());
        }
    }

    @Override
    protected void _tcpDecrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        while (buffer.hasRemaining()) {
            int remaining;
            log.debug("id:{} remaining {} payloadLenRead:{} payloadRead:{}", new Object[]{this.hashCode(), buffer.hasRemaining(), this.payloadLenRead, this.payloadRead});
            if (this.payloadRead == 0) {
                int remaining2;
                int wantLen = 2 + AesGcmCrypto.getTagLength() - this.payloadLenRead;
                if (wantLen > (remaining2 = buffer.remaining())) {
                    buffer.get(this.decBuffer, this.payloadLenRead, remaining2);
                    this.payloadLenRead += remaining2;
                    return;
                }
                buffer.get(this.decBuffer, this.payloadLenRead, wantLen);
                this.decCipher.init(false, this.getCipherParameters(false));
                this.decCipher.doFinal(this.decBuffer, this.decCipher.processBytes(this.decBuffer, 0, 2 + AesGcmCrypto.getTagLength(), this.decBuffer, 0));
                AesGcmCrypto.increment(this.decNonce);
            }
            short size = ByteBuffer.wrap(this.decBuffer, 0, 2).getShort();
            log.debug("payload length:{},remaining:{},payloadRead:{}", new Object[]{(int)size, buffer.remaining(), this.payloadRead});
            if (size == 0) {
                return;
            }
            int wantLen = AesGcmCrypto.getTagLength() + size - this.payloadRead;
            if (wantLen > (remaining = buffer.remaining())) {
                buffer.get(this.decBuffer, 2 + AesGcmCrypto.getTagLength() + this.payloadRead, remaining);
                this.payloadRead += remaining;
                return;
            }
            buffer.get(this.decBuffer, 2 + AesGcmCrypto.getTagLength() + this.payloadRead, wantLen);
            this.decCipher.init(false, this.getCipherParameters(false));
            this.decCipher.doFinal(this.decBuffer, 2 + AesGcmCrypto.getTagLength() + this.decCipher.processBytes(this.decBuffer, 2 + AesGcmCrypto.getTagLength(), size + AesGcmCrypto.getTagLength(), this.decBuffer, 2 + AesGcmCrypto.getTagLength()));
            AesGcmCrypto.increment(this.decNonce);
            this.payloadLenRead = 0;
            this.payloadRead = 0;
            stream.writeBytes(this.decBuffer, 2 + AesGcmCrypto.getTagLength(), (int)size);
        }
    }

    @Override
    protected void _udpEncrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int remaining = buffer.remaining();
        buffer.get(this.encBuffer, 0, remaining);
        this.encCipher.init(true, this.getCipherParameters(true));
        this.encCipher.doFinal(this.encBuffer, this.encCipher.processBytes(this.encBuffer, 0, remaining, this.encBuffer, 0));
        stream.writeBytes(this.encBuffer, 0, remaining + AesGcmCrypto.getTagLength());
    }

    @Override
    protected void _udpDecrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int remaining = buffer.remaining();
        buffer.get(this.decBuffer, 0, remaining);
        this.decCipher.init(false, this.getCipherParameters(false));
        this.decCipher.doFinal(this.decBuffer, this.decCipher.processBytes(this.decBuffer, 0, remaining, this.decBuffer, 0));
        stream.writeBytes(this.decBuffer, 0, remaining - AesGcmCrypto.getTagLength());
    }
}

