/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.encryption.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.modes.ChaCha20Poly1305;
import org.rx.net.shadowsocks.encryption.CryptoAeadBase;

public class ChaCha20Poly1305Crypto
extends CryptoAeadBase {
    public ChaCha20Poly1305Crypto(String name, String password) {
        super(name, password);
    }

    @Override
    protected int getKeyLength() {
        return 32;
    }

    @Override
    protected int getSaltLength() {
        return 32;
    }

    @Override
    protected AEADCipher getCipher(boolean isEncrypted) {
        return new ChaCha20Poly1305();
    }

    @Override
    protected void _tcpEncrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        while (buffer.hasRemaining()) {
            int nr = Math.min(buffer.remaining(), PAYLOAD_SIZE_MASK);
            ByteBuffer.wrap(this.encBuffer).putShort((short)nr);
            this.encCipher.init(true, this.getCipherParameters(true));
            this.encCipher.doFinal(this.encBuffer, this.encCipher.processBytes(this.encBuffer, 0, 2, this.encBuffer, 0));
            stream.writeBytes(this.encBuffer, 0, 2 + ChaCha20Poly1305Crypto.getTagLength());
            ChaCha20Poly1305Crypto.increment(this.encNonce);
            buffer.get(this.encBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength(), nr);
            this.encCipher.init(true, this.getCipherParameters(true));
            this.encCipher.doFinal(this.encBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength() + this.encCipher.processBytes(this.encBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength(), nr, this.encBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength()));
            ChaCha20Poly1305Crypto.increment(this.encNonce);
            stream.writeBytes(this.encBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength(), nr + ChaCha20Poly1305Crypto.getTagLength());
        }
    }

    @Override
    protected void _tcpDecrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        while (buffer.hasRemaining()) {
            int remaining;
            short size;
            if (this.payloadRead == 0) {
                int remaining2;
                int wantLen = 2 + ChaCha20Poly1305Crypto.getTagLength() - this.payloadLenRead;
                if (wantLen > (remaining2 = buffer.remaining())) {
                    buffer.get(this.decBuffer, this.payloadLenRead, remaining2);
                    this.payloadLenRead += remaining2;
                    return;
                }
                buffer.get(this.decBuffer, this.payloadLenRead, wantLen);
                this.decCipher.init(false, this.getCipherParameters(false));
                this.decCipher.doFinal(this.decBuffer, this.decCipher.processBytes(this.decBuffer, 0, 2 + ChaCha20Poly1305Crypto.getTagLength(), this.decBuffer, 0));
                ChaCha20Poly1305Crypto.increment(this.decNonce);
            }
            if ((size = ByteBuffer.wrap(this.decBuffer, 0, 2).getShort()) == 0) {
                return;
            }
            int wantLen = ChaCha20Poly1305Crypto.getTagLength() + size - this.payloadRead;
            if (wantLen > (remaining = buffer.remaining())) {
                buffer.get(this.decBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength() + this.payloadRead, remaining);
                this.payloadRead += remaining;
                return;
            }
            buffer.get(this.decBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength() + this.payloadRead, wantLen);
            this.decCipher.init(false, this.getCipherParameters(false));
            this.decCipher.doFinal(this.decBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength() + this.decCipher.processBytes(this.decBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength(), size + ChaCha20Poly1305Crypto.getTagLength(), this.decBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength()));
            ChaCha20Poly1305Crypto.increment(this.decNonce);
            this.payloadLenRead = 0;
            this.payloadRead = 0;
            stream.writeBytes(this.decBuffer, 2 + ChaCha20Poly1305Crypto.getTagLength(), (int)size);
        }
    }

    @Override
    protected void _udpEncrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int remaining = buffer.remaining();
        buffer.get(this.encBuffer, 0, remaining);
        this.encCipher.init(true, this.getCipherParameters(true));
        this.encCipher.doFinal(this.encBuffer, this.encCipher.processBytes(this.encBuffer, 0, remaining, this.encBuffer, 0));
        stream.writeBytes(this.encBuffer, 0, remaining + ChaCha20Poly1305Crypto.getTagLength());
    }

    @Override
    protected void _udpDecrypt(byte[] data, ByteBuf stream) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int remaining = buffer.remaining();
        buffer.get(this.decBuffer, 0, remaining);
        this.decCipher.init(false, this.getCipherParameters(false));
        this.decCipher.doFinal(this.decBuffer, this.decCipher.processBytes(this.decBuffer, 0, remaining, this.decBuffer, 0));
        stream.writeBytes(this.decBuffer, 0, remaining - ChaCha20Poly1305Crypto.getTagLength());
    }
}

