/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.encryption.impl;

import io.netty.buffer.ByteBuf;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.rx.codec.CodecUtil;
import org.rx.net.shadowsocks.encryption.CryptoSteamBase;

public class Rc4Md5Crypto
extends CryptoSteamBase {
    public Rc4Md5Crypto(String name, String password) {
        super(name, password);
    }

    @Override
    protected int getIVLength() {
        return 16;
    }

    @Override
    protected int getKeyLength() {
        return 16;
    }

    @Override
    protected SecretKey getKey() {
        return new SecretKeySpec(this._ssKey.getEncoded(), "AES");
    }

    @Override
    protected StreamCipher getCipher(boolean isEncrypted) {
        return new RC4Engine();
    }

    @Override
    protected CipherParameters getCipherParameters(byte[] iv) {
        byte[] bts = new byte[this._keyLength + this._ivLength];
        System.arraycopy(this._key.getEncoded(), 0, bts, 0, this._keyLength);
        System.arraycopy(iv, 0, bts, this._keyLength, this._ivLength);
        return new KeyParameter(CodecUtil.md5(bts));
    }

    @Override
    protected void _encrypt(byte[] data, ByteBuf stream) {
        byte[] buffer = new byte[data.length];
        int noBytesProcessed = this.encCipher.processBytes(data, 0, data.length, buffer, 0);
        stream.writeBytes(buffer, 0, noBytesProcessed);
    }

    @Override
    protected void _decrypt(byte[] data, ByteBuf stream) {
        byte[] buffer = new byte[data.length];
        int noBytesProcessed = this.decCipher.processBytes(data, 0, data.length, buffer, 0);
        stream.writeBytes(buffer, 0, noBytesProcessed);
    }
}

