/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.shadowsocks.socks5;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socksx.SocksMessage;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.rx.exception.TraceHandler;
import org.rx.net.Sockets;
import org.rx.net.shadowsocks.SSCommon;

@ChannelHandler.Sharable
public final class SocksServerHandler
extends SimpleChannelInboundHandler<SocksMessage> {
    public static final SocksServerHandler DEFAULT = new SocksServerHandler();

    private SocksServerHandler() {
    }

    public void channelRead0(ChannelHandlerContext ctx, SocksMessage socksRequest) throws Exception {
        switch (socksRequest.version()) {
            case SOCKS5: {
                if (socksRequest instanceof Socks5InitialRequest) {
                    ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CommandRequestDecoder()});
                    ctx.write((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.NO_AUTH));
                    break;
                }
                if (socksRequest instanceof Socks5CommandRequest) {
                    Socks5CommandRequest socks5CmdRequest = (Socks5CommandRequest)socksRequest;
                    if (socks5CmdRequest.type() == Socks5CommandType.CONNECT) {
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "0.0.0.0", 0));
                        ctx.channel().attr(SSCommon.REMOTE_SOCKS5_DEST).set((Object)socks5CmdRequest);
                        break;
                    }
                    if (socks5CmdRequest.type() == Socks5CommandType.UDP_ASSOCIATE) {
                        ctx.pipeline().remove((ChannelHandler)this);
                        InetSocketAddress bindAddr = (InetSocketAddress)ctx.channel().localAddress();
                        InetAddress bindId = bindAddr.getAddress();
                        Socks5AddressType bindAddrType = bindId instanceof Inet6Address ? Socks5AddressType.IPv6 : Socks5AddressType.IPv4;
                        ctx.channel().writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, bindAddrType, bindId.getHostAddress(), bindAddr.getPort()));
                        break;
                    }
                    ctx.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, socks5CmdRequest.dstAddrType())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    break;
                }
                ctx.close();
                break;
            }
            default: {
                ctx.close();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        TraceHandler.INSTANCE.log(cause);
        Sockets.closeOnFlushed(ctx.channel());
    }
}

