/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.proxy.ProxyConnectException;
import org.apache.commons.collections4.CollectionUtils;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BackendRelayHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(BackendRelayHandler.class);
    public static final BackendRelayHandler DEFAULT = new BackendRelayHandler();

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel outbound = ctx.channel();
        SocksContext sc = SocksContext.ctx(outbound);
        if (CollectionUtils.isEmpty(sc.pendingPackages)) {
            return;
        }
        log.debug("RELAY {} => {}[{}] flush packets", new Object[]{sc.inbound.remoteAddress(), outbound.localAddress(), outbound.remoteAddress()});
        Sockets.writeAndFlush(outbound, sc.pendingPackages);
        super.channelActive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Channel outbound = ctx.channel();
        SocksContext sc = SocksContext.ctx(outbound);
        log.debug("RELAY {}[{}] => {}", new Object[]{outbound.remoteAddress(), outbound.localAddress(), sc.inbound.remoteAddress()});
        sc.inbound.writeAndFlush(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SocksContext sc = SocksContext.ctx(ctx.channel());
        Sockets.closeOnFlushed(sc.inbound);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Channel outbound = ctx.channel();
        SocksContext sc = SocksContext.ctx(outbound);
        if (cause instanceof ProxyConnectException) {
            log.warn("RELAY {}[{}] => {} thrown\n{}", new Object[]{outbound.remoteAddress(), outbound.localAddress(), sc.inbound.remoteAddress(), cause.getMessage()});
        } else {
            log.warn("RELAY {}[{}] => {} thrown", new Object[]{outbound.remoteAddress(), outbound.localAddress(), sc.inbound.remoteAddress(), cause});
        }
        Sockets.closeOnFlushed(outbound);
    }
}

