/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.rx.bean.DateTime;
import org.rx.core.Extends;
import org.rx.core.Tasks;
import org.rx.io.KeyValueStore;
import org.rx.io.KeyValueStoreConfig;
import org.rx.net.socks.Authenticator;
import org.rx.net.socks.SocksUser;

final class DbAuthenticator
implements Authenticator {
    final KeyValueStore<String, SocksUser> store;

    public int size() {
        return this.store.size();
    }

    public DbAuthenticator(List<SocksUser> initUsers, Integer apiPort) {
        KeyValueStoreConfig config = KeyValueStoreConfig.newConfig(String.class, SocksUser.class);
        if (apiPort != null) {
            config.setApiPort(apiPort);
            config.setApiReturnJson(true);
        }
        this.store = new KeyValueStore(config);
        if (!CollectionUtils.isEmpty(initUsers)) {
            for (SocksUser usr : initUsers) {
                SocksUser user = this.store.computeIfAbsent(usr.getUsername(), SocksUser::new);
                user.setPassword(usr.getPassword());
                user.setMaxIpCount(usr.getMaxIpCount());
                this.store.fastPut(user.getUsername(), user);
            }
        }
        Tasks.scheduleDaily(() -> {
            this.resetIp();
            if (DateTime.now().getDay() == 1) {
                this.resetData();
            }
        }, "01:00:00");
    }

    @Override
    public SocksUser login(String username, String password) {
        SocksUser user = this.store.get(username);
        if (user == null) {
            return null;
        }
        if (!Extends.eq(user.getPassword(), password)) {
            return null;
        }
        return user;
    }

    public void save(@NonNull SocksUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.store.fastPut(user.getUsername(), user);
    }

    public void delete(@NonNull SocksUser user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.store.fastRemove(user.getUsername());
    }

    public void resetIp() {
        for (SocksUser user : this.store.values()) {
            boolean changed = false;
            Map<InetAddress, SocksUser.LoginInfo> loginIps = user.getLoginIps();
            for (Map.Entry<InetAddress, SocksUser.LoginInfo> lEntry : loginIps.entrySet()) {
                DateTime latestTime = lEntry.getValue().latestTime;
                if (latestTime == null || !latestTime.before(DateTime.now().addDays(-2))) continue;
                loginIps.remove(lEntry.getKey());
                changed = true;
            }
            if (!changed) continue;
            this.save(user);
        }
    }

    public void resetData() {
        for (SocksUser usr : this.store.values()) {
            for (SocksUser.LoginInfo l : usr.getLoginIps().values()) {
                l.totalReadBytes.set(0L);
                l.totalWriteBytes.set(0L);
            }
            usr.lastResetTime = DateTime.now();
        }
    }
}

