/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class FrontendRelayHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(FrontendRelayHandler.class);
    public static final FrontendRelayHandler DEFAULT = new FrontendRelayHandler();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Channel inbound = ctx.channel();
        SocksContext sc = SocksContext.ctx(inbound);
        if (!sc.outbound.isActive()) {
            if (sc.pendingPackages != null) {
                log.debug("PENDING_QUEUE {} => {} pend a packet", (Object)inbound.remoteAddress(), (Object)sc.outbound);
                sc.pendingPackages.add(msg);
            }
            return;
        }
        log.debug("RELAY {} => {}[{}]", new Object[]{inbound.remoteAddress(), sc.outbound.localAddress(), sc.outbound.remoteAddress()});
        sc.outbound.writeAndFlush(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel inbound = ctx.channel();
        SocksContext sc = SocksContext.ctx(inbound);
        Sockets.closeOnFlushed(sc.outbound);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Channel inbound = ctx.channel();
        SocksContext sc = SocksContext.ctx(inbound);
        log.warn("RELAY {} => {}[{}] thrown", new Object[]{inbound.remoteAddress(), sc.outbound.localAddress(), sc.outbound.remoteAddress(), cause});
        Sockets.closeOnFlushed(inbound);
    }
}

