/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyChannelIdleHandler
extends IdleStateHandler {
    private static final Logger log = LoggerFactory.getLogger(ProxyChannelIdleHandler.class);

    public ProxyChannelIdleHandler(int readerIdleTimeSeconds, int writerIdleTimeSeconds) {
        super(readerIdleTimeSeconds, writerIdleTimeSeconds, 0);
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) {
        log.info("{} {} idle: {}", new Object[]{Sockets.protocolName(ctx.channel()), ctx.channel(), evt.state()});
        Sockets.closeOnFlushed(ctx.channel());
        SocksContext sc = SocksContext.ctx(ctx.channel());
        if (sc.onClose != null) {
            sc.onClose.invoke();
        }
        super.channelIdle(ctx, evt);
    }
}

