/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import java.net.InetSocketAddress;
import lombok.NonNull;
import org.rx.bean.DateTime;
import org.rx.core.Extends;
import org.rx.core.Sys;
import org.rx.io.Bytes;
import org.rx.net.Sockets;
import org.rx.net.socks.Authenticator;
import org.rx.net.socks.DbAuthenticator;
import org.rx.net.socks.SocksUser;
import org.rx.net.support.SocksSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyManageHandler
extends ChannelTrafficShapingHandler {
    private static final Logger log = LoggerFactory.getLogger(ProxyManageHandler.class);
    private final Authenticator authenticator;
    private SocksUser user = SocksUser.ANONYMOUS;
    private SocksUser.LoginInfo info;
    private long activeTime;

    public static ProxyManageHandler get(ChannelHandlerContext ctx) {
        return (ProxyManageHandler)ctx.pipeline().get(ProxyManageHandler.class.getSimpleName());
    }

    public ProxyManageHandler(Authenticator authenticator, long checkInterval) {
        super(checkInterval);
        this.authenticator = authenticator;
    }

    public void setUser(@NonNull SocksUser user, ChannelHandlerContext ctx) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.user = user;
        InetSocketAddress realEp = (InetSocketAddress)SocksSupport.ENDPOINT_TRACER.head(ctx.channel());
        this.info = user.getLoginIps().computeIfAbsent(realEp.getAddress(), SocksUser.LoginInfo::new);
        if (user.getMaxIpCount() != -1 && user.getLoginIps().size() > user.getMaxIpCount()) {
            log.error("SocksUser {} maxIpCount={}\nconnectedIps={} incomingIp={}", new Object[]{user.getUsername(), user.getMaxIpCount(), user.getLoginIps().keySet(), realEp});
            Sockets.closeOnFlushed(ctx.channel());
            return;
        }
        ++this.info.refCnt;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.activeTime = System.nanoTime();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        long elapsed = System.nanoTime() - this.activeTime;
        TrafficCounter trafficCounter = this.trafficCounter();
        long readBytes = trafficCounter.cumulativeReadBytes();
        long writeBytes = trafficCounter.cumulativeWrittenBytes();
        if (this.info != null) {
            DateTime now = DateTime.now();
            if (this.info.latestTime == null || this.info.latestTime.before(now)) {
                this.info.latestTime = now;
            }
            this.info.totalActiveSeconds.addAndGet(elapsed / 1000000L / 1000L);
            this.info.totalReadBytes.addAndGet(writeBytes);
            this.info.totalWriteBytes.addAndGet(readBytes);
        }
        Extends.tryAs(this.authenticator, DbAuthenticator.class, p -> p.save(this.user));
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        log.info("usr={} <-> {} elapsed={} readBytes={} writeBytes={}", new Object[]{this.user.getUsername(), remoteAddress, Sys.formatNanosElapsed(elapsed), Bytes.readableByteSize(readBytes), Bytes.readableByteSize(writeBytes)});
        super.channelInactive(ctx);
    }

    public SocksUser getUser() {
        return this.user;
    }
}

