/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.rx.core.StringBuilder;
import org.rx.core.Tasks;
import org.rx.exception.TraceHandler;
import org.rx.net.AESCodec;
import org.rx.net.SocketConfig;
import org.rx.net.Sockets;
import org.rx.net.TransportFlags;
import org.rx.net.socks.BackendRelayHandler;
import org.rx.net.socks.FrontendRelayHandler;
import org.rx.net.socks.ProxyChannelIdleHandler;
import org.rx.net.socks.ProxyManageHandler;
import org.rx.net.socks.Socks5UdpAssociateHandler;
import org.rx.net.socks.SocksConfig;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.SocksProxyServer;
import org.rx.net.socks.upstream.Socks5ProxyHandler;
import org.rx.net.support.SocksSupport;
import org.rx.net.support.UnresolvedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Socks5CommandRequestHandler
extends SimpleChannelInboundHandler<DefaultSocks5CommandRequest> {
    private static final Logger log = LoggerFactory.getLogger(Socks5CommandRequestHandler.class);
    public static final Socks5CommandRequestHandler DEFAULT = new Socks5CommandRequestHandler();

    protected void channelRead0(ChannelHandlerContext inbound, DefaultSocks5CommandRequest msg) {
        ChannelPipeline pipeline = inbound.pipeline();
        pipeline.remove(Socks5CommandRequestDecoder.class.getSimpleName());
        pipeline.remove((ChannelHandler)this);
        SocksProxyServer server = SocksContext.server(inbound.channel());
        log.debug("socks5[{}] {} {}/{}:{}", new Object[]{server.getConfig().getListenPort(), msg.type(), msg.dstAddrType(), msg.dstAddr(), msg.dstPort()});
        if (server.isAuthEnabled() && ProxyManageHandler.get(inbound).getUser().isAnonymous()) {
            inbound.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FORBIDDEN, msg.dstAddrType())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        UnresolvedEndpoint dstEp = new UnresolvedEndpoint(msg.dstAddr(), msg.dstPort());
        String dstEpHost = dstEp.getHost();
        if (dstEpHost.endsWith("x.f-li.cn")) {
            UnresolvedEndpoint realEp = (UnresolvedEndpoint)SocksSupport.fakeDict().get(new BigInteger(dstEpHost.substring(0, dstEpHost.length() - "x.f-li.cn".length())));
            if (realEp == null) {
                log.error("socks5[{}] recover dstEp {} fail", (Object)server.getConfig().getListenPort(), (Object)dstEp);
            } else {
                log.info("socks5[{}] recover dstEp {}[{}]", new Object[]{server.getConfig().getListenPort(), dstEp, realEp});
                dstEp = realEp;
            }
        }
        if (msg.type() == Socks5CommandType.CONNECT) {
            SocksContext e = new SocksContext((InetSocketAddress)inbound.channel().remoteAddress(), dstEp);
            server.raiseEvent(server.onRoute, e);
            this.connect(inbound.channel(), msg.dstAddrType(), e);
        } else if (msg.type() == Socks5CommandType.UDP_ASSOCIATE) {
            pipeline.remove(ProxyChannelIdleHandler.class.getSimpleName());
            int max = Math.max(server.config.getUdpReadTimeoutSeconds(), server.config.getUdpWriteTimeoutSeconds());
            Tasks.setTimeout(() -> {
                log.info("UdpAssociate client close");
                Sockets.closeOnFlushed(inbound.channel());
            }, (long)max * 1000L);
            pipeline.addLast(new ChannelHandler[]{Socks5UdpAssociateHandler.DEFAULT});
            InetSocketAddress bindEp = (InetSocketAddress)inbound.channel().localAddress();
            Socks5AddressType bindAddrType = bindEp.getAddress() instanceof Inet6Address ? Socks5AddressType.IPv6 : Socks5AddressType.IPv4;
            inbound.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, bindAddrType, bindEp.getHostString(), bindEp.getPort()));
        } else {
            log.warn("Command {} not support", (Object)msg.type());
            inbound.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.COMMAND_UNSUPPORTED, msg.dstAddrType())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void connect(Channel inbound, Socks5AddressType dstAddrType, SocksContext e) {
        SocksProxyServer server = SocksContext.server(inbound);
        Sockets.bootstrap((EventLoopGroup)inbound.eventLoop(), (SocketConfig)server.getConfig(), outbound -> {
            e.getUpstream().initChannel((Channel)outbound);
            SocksContext.server((Channel)outbound, server);
            SocksContext.mark(inbound, (Channel)outbound, e, true);
            inbound.pipeline().addLast(new ChannelHandler[]{FrontendRelayHandler.DEFAULT});
        }).connect((SocketAddress)e.getUpstream().getDestination().socketAddress()).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            Socks5ProxyHandler proxyHandler;
            if (!f.isSuccess()) {
                if (server.onReconnecting != null) {
                    server.raiseEvent(server.onReconnecting, e);
                    if (!e.isCancel() && e.isUpstreamChanged()) {
                        e.reset();
                        this.connect(inbound, dstAddrType, e);
                        return;
                    }
                }
                TraceHandler.INSTANCE.log("socks5[{}] connect {}[{}] fail", server.getConfig().getListenPort(), e.getUpstream().getDestination(), e.firstDestination, f.cause());
                inbound.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, dstAddrType)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            Channel outbound = f.channel();
            StringBuilder aesMsg = new StringBuilder();
            SocksConfig config = server.getConfig();
            if (server.aesRouter(e.firstDestination) && (proxyHandler = (Socks5ProxyHandler)outbound.pipeline().get(Socks5ProxyHandler.class)) != null) {
                proxyHandler.setHandshakeCallback(() -> {
                    if (config.getTransportFlags().has(new TransportFlags[]{TransportFlags.BACKEND_COMPRESS})) {
                        ChannelHandler[] handlers = new AESCodec(config.getAesKey()).channelHandlers();
                        for (int i = handlers.length - 1; i > -1; --i) {
                            ChannelHandler handler = handlers[i];
                            outbound.pipeline().addAfter("ZIP_DECODER", handler.getClass().getSimpleName(), handler);
                        }
                        aesMsg.append("[BACKEND_AES]");
                    }
                    this.relay(inbound, outbound, dstAddrType, e, aesMsg);
                });
                return;
            }
            this.relay(inbound, outbound, dstAddrType, e, aesMsg);
        }));
    }

    private void relay(Channel inbound, Channel outbound, Socks5AddressType dstAddrType, SocksContext e, StringBuilder extMsg) {
        UnresolvedEndpoint dstEp = e.getUpstream().getDestination();
        outbound.pipeline().addLast(new ChannelHandler[]{BackendRelayHandler.DEFAULT});
        inbound.writeAndFlush((Object)new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, dstAddrType)).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                Sockets.closeOnFlushed(f.channel());
                return;
            }
            SocksProxyServer server = SocksContext.server(inbound);
            SocksConfig config = server.getConfig();
            if (server.aesRouter(e.firstDestination) && config.getTransportFlags().has(new TransportFlags[]{TransportFlags.FRONTEND_COMPRESS})) {
                ChannelHandler[] handlers = new AESCodec(config.getAesKey()).channelHandlers();
                for (int i = handlers.length - 1; i > -1; --i) {
                    ChannelHandler handler = handlers[i];
                    inbound.pipeline().addAfter("ZIP_DECODER", handler.getClass().getSimpleName(), handler);
                }
                extMsg.append("[FRONTEND_AES]");
            }
            log.info("socks5[{}] {} => {} connected, dstEp={}[{}] {}", new Object[]{config.getListenPort(), inbound.localAddress(), outbound.remoteAddress(), dstEp, e.firstDestination, extMsg.toString()});
        }));
    }
}

