/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socksx.SocksVersion;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import org.rx.core.Sys;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.SocksProxyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Socks5InitialRequestHandler
extends SimpleChannelInboundHandler<DefaultSocks5InitialRequest> {
    private static final Logger log = LoggerFactory.getLogger(Socks5InitialRequestHandler.class);
    public static final Socks5InitialRequestHandler DEFAULT = new Socks5InitialRequestHandler();

    protected void channelRead0(ChannelHandlerContext ctx, DefaultSocks5InitialRequest msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.remove(Socks5InitialRequestDecoder.class.getSimpleName());
        pipeline.remove((ChannelHandler)this);
        SocksProxyServer server = SocksContext.server(ctx.channel());
        Set<InetAddress> whiteList = server.getConfig().getWhiteList();
        InetSocketAddress remoteEp = (InetSocketAddress)ctx.channel().remoteAddress();
        if (!Sockets.isLanIp(remoteEp.getAddress()) && !whiteList.contains(remoteEp.getAddress())) {
            log.warn("socks5[{}] whiteList={}\n{} access blocked", new Object[]{server.getConfig().getListenPort(), Sys.toJsonString(whiteList), remoteEp});
            ctx.close();
            return;
        }
        if (msg.decoderResult().isFailure() || !msg.version().equals((Object)SocksVersion.SOCKS5)) {
            log.warn("socks5[{}] error protocol", (Object)server.getConfig().getListenPort(), (Object)msg.decoderResult().cause());
            ctx.writeAndFlush((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.UNACCEPTED)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.writeAndFlush((Object)new DefaultSocks5InitialResponse(server.isAuthEnabled() ? Socks5AuthMethod.PASSWORD : Socks5AuthMethod.NO_AUTH));
    }
}

