/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.rx.net.socks.ProxyManageHandler;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.SocksProxyServer;
import org.rx.net.socks.SocksUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Socks5PasswordAuthRequestHandler
extends SimpleChannelInboundHandler<DefaultSocks5PasswordAuthRequest> {
    private static final Logger log = LoggerFactory.getLogger(Socks5PasswordAuthRequestHandler.class);
    public static final Socks5PasswordAuthRequestHandler DEFAULT = new Socks5PasswordAuthRequestHandler();

    protected void channelRead0(ChannelHandlerContext ctx, DefaultSocks5PasswordAuthRequest msg) {
        SocksUser user;
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.remove(Socks5PasswordAuthRequestDecoder.class.getSimpleName());
        pipeline.remove((ChannelHandler)this);
        SocksProxyServer server = SocksContext.server(ctx.channel());
        if (server.getAuthenticator() == null || (user = server.getAuthenticator().login(msg.username(), msg.password())) == null) {
            ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.writeAndFlush((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS));
        ProxyManageHandler.get(ctx).setUser(user, ctx);
    }
}

