/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.rx.net.AuthenticEndpoint;
import org.rx.net.Sockets;
import org.rx.net.socks.ProxyChannelIdleHandler;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.SocksProxyServer;
import org.rx.net.socks.UdpManager;
import org.rx.net.socks.upstream.Upstream;
import org.rx.net.support.UnresolvedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Socks5UdpRelayHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final Logger log = LoggerFactory.getLogger(Socks5UdpRelayHandler.class);
    public static final Socks5UdpRelayHandler DEFAULT = new Socks5UdpRelayHandler();

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket in) throws Exception {
        ByteBuf inBuf = (ByteBuf)in.content();
        if (inBuf.readableBytes() < 4) {
            return;
        }
        Channel inbound = ctx.channel();
        SocksProxyServer server = SocksContext.server(inbound);
        InetSocketAddress srcEp = (InetSocketAddress)in.sender();
        if (!Sockets.isLanIp(srcEp.getAddress()) && !server.config.getWhiteList().contains(srcEp.getAddress())) {
            log.warn("security error, package from {}", (Object)srcEp);
            return;
        }
        UnresolvedEndpoint dstEp = UdpManager.socks5Decode(inBuf);
        Channel outbound = UdpManager.openChannel(srcEp, k -> {
            SocksContext e = new SocksContext(srcEp, dstEp);
            server.raiseEvent(server.onUdpRoute, e);
            Upstream upstream = e.getUpstream();
            return Sockets.udpBootstrap(server.config.getMemoryMode(), ob -> {
                SocksContext.server((Channel)ob, server);
                SocksContext.mark(inbound, (Channel)ob, e, false);
                e.onClose = () -> UdpManager.closeChannel(srcEp);
                upstream.initChannel((Channel)ob);
                ob.pipeline().addLast(new ChannelHandler[]{new ProxyChannelIdleHandler(server.config.getUdpReadTimeoutSeconds(), server.config.getUdpWriteTimeoutSeconds()), UdpBackendRelayHandler.DEFAULT});
            }).bind(0).addListener((GenericFutureListener)Sockets.logBind(0)).syncUninterruptibly().channel();
        });
        SocksContext sc = SocksContext.ctx(outbound);
        UnresolvedEndpoint upDstEp = dstEp;
        AuthenticEndpoint upSvrEp = sc.getUpstream().getSocksServer();
        if (upSvrEp != null) {
            upDstEp = new UnresolvedEndpoint(upSvrEp.getEndpoint());
            inBuf.readerIndex(0);
        }
        UdpManager.pendOrWritePacket(outbound, new DatagramPacket(inBuf.retain(), upDstEp.socketAddress()));
        log.debug("socks5[{}] UDP OUT {} => {}[{}]", new Object[]{server.config.getListenPort(), srcEp, upDstEp, dstEp});
    }

    @ChannelHandler.Sharable
    public static class UdpBackendRelayHandler
    extends SimpleChannelInboundHandler<DatagramPacket> {
        private static final Logger log = LoggerFactory.getLogger(UdpBackendRelayHandler.class);
        public static final UdpBackendRelayHandler DEFAULT = new UdpBackendRelayHandler();

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket out) throws Exception {
            Channel outbound = ctx.channel();
            SocksContext sc = SocksContext.ctx(outbound);
            InetSocketAddress srcEp = sc.source;
            UnresolvedEndpoint dstEp = sc.firstDestination;
            ByteBuf outBuf = (ByteBuf)out.content();
            SocksProxyServer server = SocksContext.server(outbound);
            if (sc.upstream.getSocksServer() == null) {
                outBuf = UdpManager.socks5Encode(outBuf, dstEp);
            } else {
                outBuf.retain();
            }
            sc.inbound.writeAndFlush((Object)new DatagramPacket(outBuf, srcEp));
            log.debug("socks5[{}] UDP IN {}[{}] => {}", new Object[]{server.config.getListenPort(), out.sender(), dstEp, srcEp});
        }
    }
}

