/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.rx.net.SocketConfig;
import org.rx.net.Sockets;

public class SocksConfig
extends SocketConfig {
    private static final long serialVersionUID = 3526543718065617052L;
    private final int listenPort;
    private int trafficShapingInterval = 10000;
    private int readTimeoutSeconds = 240;
    private int writeTimeoutSeconds;
    private int udpReadTimeoutSeconds = 1200;
    private int udpWriteTimeoutSeconds;
    private boolean enableUdp2raw;
    private List<InetSocketAddress> udp2rawServers;
    private final AtomicReference<Object> whiteList = new AtomicReference();

    private Set<InetAddress> whiteList() {
        ConcurrentHashMap.KeySetView list = ConcurrentHashMap.newKeySet(1);
        list.add(Sockets.getLoopbackAddress());
        return list;
    }

    public SocksConfig(int listenPort) {
        this.listenPort = listenPort;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public int getTrafficShapingInterval() {
        return this.trafficShapingInterval;
    }

    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public int getWriteTimeoutSeconds() {
        return this.writeTimeoutSeconds;
    }

    public int getUdpReadTimeoutSeconds() {
        return this.udpReadTimeoutSeconds;
    }

    public int getUdpWriteTimeoutSeconds() {
        return this.udpWriteTimeoutSeconds;
    }

    public boolean isEnableUdp2raw() {
        return this.enableUdp2raw;
    }

    public List<InetSocketAddress> getUdp2rawServers() {
        return this.udp2rawServers;
    }

    public void setTrafficShapingInterval(int trafficShapingInterval) {
        this.trafficShapingInterval = trafficShapingInterval;
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    public void setWriteTimeoutSeconds(int writeTimeoutSeconds) {
        this.writeTimeoutSeconds = writeTimeoutSeconds;
    }

    public void setUdpReadTimeoutSeconds(int udpReadTimeoutSeconds) {
        this.udpReadTimeoutSeconds = udpReadTimeoutSeconds;
    }

    public void setUdpWriteTimeoutSeconds(int udpWriteTimeoutSeconds) {
        this.udpWriteTimeoutSeconds = udpWriteTimeoutSeconds;
    }

    public void setEnableUdp2raw(boolean enableUdp2raw) {
        this.enableUdp2raw = enableUdp2raw;
    }

    public void setUdp2rawServers(List<InetSocketAddress> udp2rawServers) {
        this.udp2rawServers = udp2rawServers;
    }

    @Override
    public String toString() {
        return "SocksConfig(listenPort=" + this.getListenPort() + ", trafficShapingInterval=" + this.getTrafficShapingInterval() + ", readTimeoutSeconds=" + this.getReadTimeoutSeconds() + ", writeTimeoutSeconds=" + this.getWriteTimeoutSeconds() + ", udpReadTimeoutSeconds=" + this.getUdpReadTimeoutSeconds() + ", udpWriteTimeoutSeconds=" + this.getUdpWriteTimeoutSeconds() + ", enableUdp2raw=" + this.isEnableUdp2raw() + ", udp2rawServers=" + this.getUdp2rawServers() + ", whiteList=" + this.getWhiteList() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InetAddress> getWhiteList() {
        Object value = this.whiteList.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.whiteList;
            synchronized (atomicReference) {
                value = this.whiteList.get();
                if (value == null) {
                    Set<InetAddress> actualValue = this.whiteList();
                    value = actualValue == null ? this.whiteList : actualValue;
                    this.whiteList.set(value);
                }
            }
        }
        return (Set)(value == this.whiteList ? null : value);
    }
}

