/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import lombok.NonNull;
import org.rx.core.Delegate;
import org.rx.core.Disposable;
import org.rx.core.EventPublisher;
import org.rx.net.MemoryMode;
import org.rx.net.Sockets;
import org.rx.net.socks.Authenticator;
import org.rx.net.socks.ProxyChannelIdleHandler;
import org.rx.net.socks.ProxyManageHandler;
import org.rx.net.socks.Socks5CommandRequestHandler;
import org.rx.net.socks.Socks5InitialRequestHandler;
import org.rx.net.socks.Socks5PasswordAuthRequestHandler;
import org.rx.net.socks.Socks5UdpRelayHandler;
import org.rx.net.socks.SocksConfig;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.Udp2rawHandler;
import org.rx.net.socks.upstream.Upstream;
import org.rx.net.support.UnresolvedEndpoint;
import org.rx.util.function.PredicateFunc;
import org.rx.util.function.TripleAction;

public class SocksProxyServer
extends Disposable
implements EventPublisher<SocksProxyServer> {
    public static final TripleAction<SocksProxyServer, SocksContext> DIRECT_ROUTER = (s, e) -> e.setUpstream(new Upstream(e.getFirstDestination()));
    public static final PredicateFunc<UnresolvedEndpoint> DNS_AES_ROUTER = dstEp -> dstEp.getPort() == 53;
    public final Delegate<SocksProxyServer, SocksContext> onRoute = Delegate.create(DIRECT_ROUTER);
    public final Delegate<SocksProxyServer, SocksContext> onUdpRoute = Delegate.create(DIRECT_ROUTER);
    public final Delegate<SocksProxyServer, SocksContext> onReconnecting = Delegate.create();
    final SocksConfig config;
    final ServerBootstrap bootstrap;
    final Channel udpChannel;
    final Authenticator authenticator;
    private PredicateFunc<UnresolvedEndpoint> aesRouter;

    public boolean isAuthEnabled() {
        return this.authenticator != null;
    }

    public SocksProxyServer(SocksConfig config) {
        this(config, null);
    }

    public SocksProxyServer(@NonNull SocksConfig config, Authenticator authenticator) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.authenticator = authenticator;
        this.bootstrap = Sockets.serverBootstrap(config, channel -> {
            SocksContext.server((Channel)channel, this);
            ChannelPipeline pipeline = channel.pipeline();
            if (this.isAuthEnabled()) {
                pipeline.addLast(ProxyManageHandler.class.getSimpleName(), (ChannelHandler)new ProxyManageHandler(authenticator, config.getTrafficShapingInterval()));
            }
            pipeline.addLast(ProxyChannelIdleHandler.class.getSimpleName(), (ChannelHandler)new ProxyChannelIdleHandler(config.getReadTimeoutSeconds(), config.getWriteTimeoutSeconds()));
            Sockets.addFrontendHandler((Channel)channel, config);
            pipeline.addLast(new ChannelHandler[]{Socks5ServerEncoder.DEFAULT}).addLast(Socks5InitialRequestDecoder.class.getSimpleName(), (ChannelHandler)new Socks5InitialRequestDecoder()).addLast(Socks5InitialRequestHandler.class.getSimpleName(), (ChannelHandler)Socks5InitialRequestHandler.DEFAULT);
            if (this.isAuthEnabled()) {
                pipeline.addLast(Socks5PasswordAuthRequestDecoder.class.getSimpleName(), (ChannelHandler)new Socks5PasswordAuthRequestDecoder()).addLast(Socks5PasswordAuthRequestHandler.class.getSimpleName(), (ChannelHandler)Socks5PasswordAuthRequestHandler.DEFAULT);
            }
            pipeline.addLast(Socks5CommandRequestDecoder.class.getSimpleName(), (ChannelHandler)new Socks5CommandRequestDecoder()).addLast(Socks5CommandRequestHandler.class.getSimpleName(), (ChannelHandler)Socks5CommandRequestHandler.DEFAULT);
        });
        this.bootstrap.bind(config.getListenPort()).addListener((GenericFutureListener)Sockets.logBind(config.getListenPort()));
        int udpPort = config.getListenPort();
        this.udpChannel = Sockets.udpBootstrap("SS", MemoryMode.HIGH, channel -> {
            SocksContext.server((Channel)channel, this);
            ChannelPipeline pipeline = channel.pipeline();
            if (config.isEnableUdp2raw()) {
                pipeline.addLast(new ChannelHandler[]{Udp2rawHandler.DEFAULT});
            } else {
                Sockets.addFrontendHandler((Channel)channel, config);
                pipeline.addLast(new ChannelHandler[]{Socks5UdpRelayHandler.DEFAULT});
            }
        }).bind((SocketAddress)Sockets.newAnyEndpoint(udpPort)).addListener((GenericFutureListener)Sockets.logBind(config.getListenPort())).channel();
    }

    @Override
    protected void freeObjects() {
        Sockets.closeBootstrap(this.bootstrap);
        this.udpChannel.close();
    }

    boolean aesRouter(UnresolvedEndpoint dstEp) {
        if (this.aesRouter == null) {
            return false;
        }
        return this.aesRouter.invoke(dstEp);
    }

    public SocksConfig getConfig() {
        return this.config;
    }

    protected Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAesRouter(PredicateFunc<UnresolvedEndpoint> aesRouter) {
        this.aesRouter = aesRouter;
    }
}

