/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.rx.bean.DateTime;
import org.rx.core.Linq;
import org.rx.core.Strings;
import org.rx.core.Tasks;
import org.rx.io.Bytes;
import org.rx.net.support.IPAddress;
import org.rx.net.support.IPSearcher;
import org.rx.util.BeanMapper;

@JSONType(deserializer=JsonReader.class)
public class SocksUser
implements Serializable {
    private static final long serialVersionUID = 7845976131633777320L;
    public static final SocksUser ANONYMOUS = new SocksUser("anonymous");
    final String username;
    final Map<InetAddress, LoginInfo> loginIps = new ConcurrentHashMap<InetAddress, LoginInfo>(8);
    String password;
    int maxIpCount;
    DateTime lastResetTime;

    public boolean isAnonymous() {
        return Strings.hashEquals(ANONYMOUS.getUsername(), this.username);
    }

    public long getTotalReadBytes() {
        return (long)Linq.from(this.loginIps.values()).sum(p -> p.totalReadBytes.get());
    }

    public long getTotalWriteBytes() {
        return (long)Linq.from(this.loginIps.values()).sum(p -> p.totalWriteBytes.get());
    }

    public String getHumanTotalReadBytes() {
        return Bytes.readableByteSize(this.getTotalReadBytes());
    }

    public String getHumanTotalWriteBytes() {
        return Bytes.readableByteSize(this.getTotalWriteBytes());
    }

    public SocksUser(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public Map<InetAddress, LoginInfo> getLoginIps() {
        return this.loginIps;
    }

    public String getPassword() {
        return this.password;
    }

    public int getMaxIpCount() {
        return this.maxIpCount;
    }

    public DateTime getLastResetTime() {
        return this.lastResetTime;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setMaxIpCount(int maxIpCount) {
        this.maxIpCount = maxIpCount;
    }

    public void setLastResetTime(DateTime lastResetTime) {
        this.lastResetTime = lastResetTime;
    }

    public String toString() {
        return "SocksUser(username=" + this.getUsername() + ", loginIps=" + this.getLoginIps() + ", password=" + this.getPassword() + ", maxIpCount=" + this.getMaxIpCount() + ", lastResetTime=" + this.getLastResetTime() + ")";
    }

    public static class LoginInfo
    implements Serializable {
        private static final long serialVersionUID = 1264936011170722186L;
        final InetAddress ip;
        IPAddress ipInfo;
        DateTime latestTime;
        int refCnt;
        final AtomicLong totalActiveSeconds = new AtomicLong();
        AtomicLong totalReadBytes = new AtomicLong();
        final AtomicLong totalWriteBytes = new AtomicLong();

        public LoginInfo(InetAddress ip) {
            this.ip = ip;
            Tasks.run(() -> {
                this.ipInfo = IPSearcher.DEFAULT.search(ip.getHostAddress());
                return this.ipInfo;
            });
        }

        public InetAddress getIp() {
            return this.ip;
        }

        public IPAddress getIpInfo() {
            return this.ipInfo;
        }

        public DateTime getLatestTime() {
            return this.latestTime;
        }

        public int getRefCnt() {
            return this.refCnt;
        }

        public AtomicLong getTotalActiveSeconds() {
            return this.totalActiveSeconds;
        }

        public AtomicLong getTotalReadBytes() {
            return this.totalReadBytes;
        }

        public AtomicLong getTotalWriteBytes() {
            return this.totalWriteBytes;
        }

        public void setIpInfo(IPAddress ipInfo) {
            this.ipInfo = ipInfo;
        }

        public void setLatestTime(DateTime latestTime) {
            this.latestTime = latestTime;
        }

        public void setRefCnt(int refCnt) {
            this.refCnt = refCnt;
        }

        public void setTotalReadBytes(AtomicLong totalReadBytes) {
            this.totalReadBytes = totalReadBytes;
        }

        public String toString() {
            return "SocksUser.LoginInfo(ip=" + this.getIp() + ", ipInfo=" + this.getIpInfo() + ", latestTime=" + this.getLatestTime() + ", refCnt=" + this.getRefCnt() + ", totalActiveSeconds=" + this.getTotalActiveSeconds() + ", totalReadBytes=" + this.getTotalReadBytes() + ", totalWriteBytes=" + this.getTotalWriteBytes() + ")";
        }
    }

    public static class JsonReader
    implements ObjectReader<SocksUser> {
        public SocksUser readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            Map map = jsonReader.readObject();
            SocksUser user = new SocksUser((String)map.get("username"));
            BeanMapper.DEFAULT.map((Object)map, user);
            return user;
        }
    }
}

