/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rx.bean.Tuple;
import org.rx.io.Bytes;
import org.rx.io.GZIPStream;
import org.rx.io.MemoryStream;
import org.rx.net.AuthenticEndpoint;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksContext;
import org.rx.net.socks.SocksProxyServer;
import org.rx.net.socks.UdpManager;
import org.rx.net.socks.upstream.Upstream;
import org.rx.net.support.UnresolvedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class Udp2rawHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final Logger log = LoggerFactory.getLogger(Udp2rawHandler.class);
    public static final Udp2rawHandler DEFAULT = new Udp2rawHandler();
    static final short STREAM_MAGIC = -21264;
    static final byte STREAM_VERSION = 1;
    final Map<InetSocketAddress, Tuple<InetSocketAddress, UnresolvedEndpoint>> clientRoutes = new ConcurrentHashMap<InetSocketAddress, Tuple<InetSocketAddress, UnresolvedEndpoint>>();
    int gzipMinLength = 1000;

    protected void channelRead0(ChannelHandlerContext inbound, DatagramPacket in) throws Exception {
        ByteBuf inBuf = (ByteBuf)in.content();
        if (inBuf.readableBytes() < 4) {
            return;
        }
        SocksProxyServer server = SocksContext.server(inbound.channel());
        InetSocketAddress srcEp0 = (InetSocketAddress)in.sender();
        List<InetSocketAddress> udp2rawServers = server.config.getUdp2rawServers();
        if (udp2rawServers != null) {
            if (!udp2rawServers.contains(srcEp0) && !this.clientRoutes.containsKey(srcEp0)) {
                UnresolvedEndpoint dstEp = UdpManager.socks5Decode(inBuf);
                SocksContext e = new SocksContext(srcEp0, dstEp);
                server.raiseEvent(server.onUdpRoute, e);
                Upstream upstream = e.getUpstream();
                AuthenticEndpoint svrEp = upstream.getSocksServer();
                if (svrEp != null) {
                    ByteBuf outBuf = Bytes.directBuffer(64 + inBuf.readableBytes());
                    outBuf.writeShort(-21264);
                    outBuf.writeByte(1);
                    UdpManager.encode(outBuf, new UnresolvedEndpoint(srcEp0));
                    UdpManager.encode(outBuf, dstEp);
                    this.zip(outBuf, inBuf);
                    inbound.writeAndFlush((Object)new DatagramPacket(outBuf, svrEp.getEndpoint()));
                    return;
                }
                UnresolvedEndpoint upDstEp = upstream.getDestination();
                log.debug("UDP2RAW[{}] CLIENT DIRECT {} => {}[{}]", new Object[]{server.config.getListenPort(), srcEp0, upDstEp, dstEp});
                inbound.writeAndFlush((Object)new DatagramPacket(inBuf.retain(), upDstEp.socketAddress()));
                this.clientRoutes.put(upDstEp.socketAddress(), Tuple.of(srcEp0, dstEp));
                return;
            }
            Tuple<InetSocketAddress, UnresolvedEndpoint> upSrcs = this.clientRoutes.get(srcEp0);
            if (upSrcs != null) {
                ByteBuf outBuf = UdpManager.socks5Encode(inBuf, (UnresolvedEndpoint)upSrcs.right);
                log.debug("UDP2RAW[{}] CLIENT DIRECT {}[{}] => {}", new Object[]{server.config.getListenPort(), srcEp0, upSrcs.right, upSrcs.left});
                inbound.writeAndFlush((Object)new DatagramPacket(outBuf, (InetSocketAddress)upSrcs.left));
                return;
            }
            if (inBuf.readShort() != -21264 & inBuf.readByte() != 1) {
                log.warn("discard {} bytes", (Object)inBuf.readableBytes());
                return;
            }
            UnresolvedEndpoint srcEp = UdpManager.decode(inBuf);
            UnresolvedEndpoint dstEp = UdpManager.decode(inBuf);
            ByteBuf outBuf = UdpManager.socks5Encode(inBuf, dstEp);
            inbound.writeAndFlush((Object)new DatagramPacket(outBuf, srcEp.socketAddress()));
            return;
        }
        if (inBuf.readShort() != -21264 & inBuf.readByte() != 1) {
            log.warn("discard {} bytes", (Object)inBuf.readableBytes());
            return;
        }
        UnresolvedEndpoint srcEp = UdpManager.decode(inBuf);
        UnresolvedEndpoint dstEp = UdpManager.decode(inBuf);
        Channel outbound = UdpManager.openChannel(srcEp.socketAddress(), k -> {
            SocksContext e = new SocksContext(srcEp.socketAddress(), dstEp);
            server.raiseEvent(server.onUdpRoute, e);
            Upstream upstream = e.getUpstream();
            return Sockets.udpBootstrap(server.config.getMemoryMode(), ob -> {
                SocksContext.server((Channel)ob, server);
                upstream.initChannel((Channel)ob);
            }).bind(0).addListener((GenericFutureListener)Sockets.logBind(0)).channel();
        });
        ByteBuf outBuf = this.unzip(inBuf);
        UdpManager.pendOrWritePacket(outbound, new DatagramPacket(outBuf, dstEp.socketAddress()));
    }

    private void zip(ByteBuf outBuf, ByteBuf inBuf) {
        if (inBuf.readableBytes() < this.gzipMinLength) {
            outBuf.writeByte(1);
            outBuf.writeBytes(inBuf);
            return;
        }
        outBuf.writeByte(2);
        int w = outBuf.writerIndex();
        int unzipLen = inBuf.readableBytes();
        try (GZIPStream stream = new GZIPStream(new MemoryStream(outBuf, true), true);){
            stream.write(inBuf);
        }
        outBuf.readerIndex(0);
        log.info("UDP2RAW ZIP {} => {}", (Object)unzipLen, (Object)(outBuf.writerIndex() - w));
    }

    private ByteBuf unzip(ByteBuf inBuf) {
        if (inBuf.readByte() == 1) {
            return inBuf.retain();
        }
        ByteBuf outBuf = Bytes.directBuffer(inBuf.readableBytes());
        try (GZIPStream stream = new GZIPStream(new MemoryStream(inBuf, false), true);){
            stream.read(outBuf);
        }
        return outBuf;
    }

    public void setGzipMinLength(int gzipMinLength) {
        this.gzipMinLength = gzipMinLength;
    }
}

