/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.socksx.v5.Socks5AddressDecoder;
import io.netty.handler.codec.socksx.v5.Socks5AddressEncoder;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.rx.core.Extends;
import org.rx.io.Bytes;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksContext;
import org.rx.net.support.UnresolvedEndpoint;
import org.rx.util.function.BiFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UdpManager {
    private static final Logger log = LoggerFactory.getLogger(UdpManager.class);
    public static final ChannelFutureListener FLUSH_PENDING_QUEUE = f -> {
        Channel outbound = f.channel();
        SocksContext sc = SocksContext.ctx(outbound);
        if (!f.isSuccess()) {
            UdpManager.closeChannel(sc.source);
            return;
        }
        ConcurrentLinkedQueue<Object> queue = sc.pendingPackages;
        if (queue == null) {
            return;
        }
        int size = queue.size();
        Sockets.writeAndFlush(outbound, queue);
        sc.pendingPackages = null;
        if (size > 0) {
            log.info("PENDING_QUEUE {} => {} flush {} packets", new Object[]{sc.source, sc.firstDestination, size});
        }
    };
    static final Map<InetSocketAddress, Channel> holder = new ConcurrentHashMap<InetSocketAddress, Channel>();

    public static void pendOrWritePacket(Channel outbound, Object packet) {
        SocksContext sc = SocksContext.ctx(outbound);
        ConcurrentLinkedQueue<Object> queue = sc.pendingPackages;
        if (queue != null && queue.add(packet)) {
            log.debug("PENDING_QUEUE {} => {} pend a packet", (Object)sc.source, (Object)sc.firstDestination);
            return;
        }
        outbound.writeAndFlush(packet);
    }

    public static Channel openChannel(InetSocketAddress incomingEp, BiFunc<InetSocketAddress, Channel> loadFn) {
        return holder.computeIfAbsent(incomingEp, loadFn);
    }

    public static void closeChannel(InetSocketAddress incomingEp) {
        Channel channel = holder.remove(incomingEp);
        if (channel == null) {
            log.error("CloseChannel fail {} <> {}", (Object)incomingEp, holder.keySet());
            return;
        }
        Extends.tryClose(SocksContext.ctx((Channel)channel).upstream);
        channel.close();
    }

    public static ByteBuf socks5Encode(ByteBuf buf, UnresolvedEndpoint dstEp) {
        ByteBuf outBuf = Bytes.directBuffer(64 + buf.readableBytes());
        outBuf.writeZero(3);
        UdpManager.encode(outBuf, dstEp);
        outBuf.writeBytes(buf);
        return outBuf;
    }

    public static UnresolvedEndpoint socks5Decode(ByteBuf buf) {
        buf.skipBytes(3);
        return UdpManager.decode(buf);
    }

    public static void encode(ByteBuf buf, UnresolvedEndpoint ep) {
        Socks5AddressType addrType = NetUtil.isValidIpV4Address((String)ep.getHost()) ? Socks5AddressType.IPv4 : (NetUtil.isValidIpV6Address((String)ep.getHost()) ? Socks5AddressType.IPv6 : Socks5AddressType.DOMAIN);
        buf.writeByte((int)addrType.byteValue());
        Socks5AddressEncoder.DEFAULT.encodeAddress(addrType, ep.getHost(), buf);
        buf.writeShort(ep.getPort());
    }

    public static UnresolvedEndpoint decode(ByteBuf buf) {
        Socks5AddressType addrType = Socks5AddressType.valueOf((byte)buf.readByte());
        String dstAddr = Socks5AddressDecoder.DEFAULT.decodeAddress(addrType, buf);
        return new UnresolvedEndpoint(dstAddr, buf.readUnsignedShort());
    }
}

