/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks.upstream;

import io.netty.channel.Channel;
import lombok.NonNull;
import org.rx.exception.InvalidException;
import org.rx.net.AuthenticEndpoint;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksConfig;
import org.rx.net.socks.upstream.Upstream;
import org.rx.net.support.UnresolvedEndpoint;
import org.rx.net.support.UpstreamSupport;
import org.rx.util.function.Func;

public class Socks5UdpUpstream
extends Upstream {
    final SocksConfig config;
    final Func<UpstreamSupport> router;

    public Socks5UdpUpstream(@NonNull UnresolvedEndpoint dstEp, @NonNull SocksConfig config, @NonNull Func<UpstreamSupport> router) {
        super(dstEp);
        if (dstEp == null) {
            throw new NullPointerException("dstEp is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (router == null) {
            throw new NullPointerException("router is marked non-null but is null");
        }
        this.config = config;
        this.router = router;
    }

    @Override
    public void initChannel(Channel channel) {
        UpstreamSupport next = this.router.invoke();
        if (next == null) {
            throw new InvalidException("ProxyHandlers is empty", new Object[0]);
        }
        AuthenticEndpoint svrEp = this.socksServer = next.getEndpoint();
        Sockets.addBackendHandler(channel, this.config, svrEp.getEndpoint());
    }
}

