/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.socks.upstream;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.rx.codec.CodecUtil;
import org.rx.core.Arrays;
import org.rx.core.Cache;
import org.rx.core.CachePolicy;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.rx.net.AuthenticEndpoint;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksConfig;
import org.rx.net.socks.upstream.Socks5ProxyHandler;
import org.rx.net.socks.upstream.Upstream;
import org.rx.net.support.SocksSupport;
import org.rx.net.support.UnresolvedEndpoint;
import org.rx.net.support.UpstreamSupport;
import org.rx.util.function.Func;

public class Socks5Upstream
extends Upstream {
    final SocksConfig config;
    final Func<UpstreamSupport> router;

    public Socks5Upstream(@NonNull UnresolvedEndpoint dstEp, @NonNull SocksConfig config, @NonNull Func<UpstreamSupport> router) {
        super(dstEp);
        if (dstEp == null) {
            throw new NullPointerException("dstEp is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (router == null) {
            throw new NullPointerException("router is marked non-null but is null");
        }
        this.config = config;
        this.router = router;
    }

    @Override
    public void initChannel(Channel channel) {
        UpstreamSupport next = this.router.invoke();
        if (next == null) {
            throw new InvalidException("ProxyHandlers is empty", new Object[0]);
        }
        AuthenticEndpoint svrEp = next.getEndpoint();
        SocksSupport support = next.getSupport();
        Sockets.addBackendHandler(channel, this.config, svrEp.getEndpoint());
        if (support != null && (SocksSupport.FAKE_IPS.contains(this.destination.getHost()) || SocksSupport.FAKE_PORTS.contains(this.destination.getPort()) || !Sockets.isValidIp(this.destination.getHost()))) {
            String dstEpStr = this.destination.toString();
            BigInteger hash = CodecUtil.hashUnsigned64(dstEpStr.getBytes(StandardCharsets.UTF_8));
            this.destination = new UnresolvedEndpoint(String.format("%s%s", hash, "x.f-li.cn"), Arrays.randomNext(SocksSupport.FAKE_PORT_OBFS));
            Cache cache = Cache.getInstance();
            if (!cache.containsKey(hash)) {
                try {
                    ((CompletableFuture)Tasks.runAsync(() -> {
                        Sys.logCtx(String.format("socks5[%s]", this.config.getListenPort()), dstEpStr);
                        support.fakeEndpoint(hash, dstEpStr);
                        return true;
                    }).whenCompleteAsync((r, e) -> {
                        if (BooleanUtils.isTrue((Boolean)r)) {
                            cache.put(hash, r, CachePolicy.absolute(300));
                        }
                    })).get(4000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    TraceHandler.INSTANCE.log(e2);
                }
            }
        }
        Socks5ProxyHandler proxyHandler = new Socks5ProxyHandler(svrEp.getEndpoint(), svrEp.getUsername(), svrEp.getPassword());
        proxyHandler.setConnectTimeoutMillis(this.config.getConnectTimeoutMillis());
        channel.pipeline().addLast(new ChannelHandler[]{proxyHandler});
    }
}

