/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.support;

import com.alibaba.fastjson2.JSONObject;
import java.net.InetAddress;
import lombok.NonNull;
import org.rx.bean.RandomList;
import org.rx.core.Extends;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.InvalidException;
import org.rx.io.KeyValueStore;
import org.rx.net.Sockets;
import org.rx.net.http.HttpClient;
import org.rx.net.support.IPAddress;
import org.rx.net.support.IPSearcher;
import org.rx.util.function.BiFunc;
import org.rx.util.function.PredicateFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ComboIPSearcher
implements IPSearcher {
    private static final Logger log = LoggerFactory.getLogger(ComboIPSearcher.class);
    static final int TIMEOUT_SECONDS = 10000;
    final RandomList<BiFunc<String, IPAddress>> apis = new RandomList();
    final RandomList<BiFunc<String, IPAddress>> dApis = new RandomList();
    final KeyValueStore<String, IPAddress> store = KeyValueStore.getInstance(String.class, IPAddress.class);

    public ComboIPSearcher() {
        this.apis.add(this::ip_Api, 90);
        this.apis.add(this::ipGeo, 40);
        this.apis.add(this::ipData, 40);
        this.apis.add(this::ipInfo, 100);
        this.apis.add(this::ipWho, 20);
        this.apis.add(this::ipApi, 2);
        this.dApis.add(this::ip_Api, 60);
        this.dApis.add(this::ipApi, 1);
    }

    @Override
    public String currentIp() {
        return (String)Tasks.randomRetry(() -> new HttpClient(10000L).get("https://api.ipify.org").toString(), () -> this.searchCurrent().getIp());
    }

    @Override
    public IPAddress searchCurrent() {
        return this.search(Sockets.getLoopbackHostAddress());
    }

    @Override
    public IPAddress search(@NonNull String host, boolean resolveHostRemotely) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), host)) {
            return this.rndRetry(host, resolveHostRemotely);
        }
        return this.store.computeIfAbsent(String.format("%s:%s", host, resolveHostRemotely ? 1 : 0), k -> {
            if (resolveHostRemotely) {
                log.info("resolveHostRemotely: {}", k);
            }
            return this.rndRetry(host, resolveHostRemotely);
        });
    }

    IPAddress rndRetry(String host, boolean resolveHostRemotely) {
        if (Sockets.isValidIp(host)) {
            resolveHostRemotely = false;
        }
        if (!resolveHostRemotely) {
            host = InetAddress.getByName(host).getHostAddress();
        }
        RandomList<BiFunc<String, IPAddress>> fns = resolveHostRemotely ? this.dApis : this.apis;
        String finalHost = host;
        return Extends.quietly(() -> (IPAddress)((BiFunc)fns.next()).invoke(finalHost), 3);
    }

    IPAddress ip_Api(String host) {
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), host)) {
            host = "";
        }
        String url = String.format("http://ip-api.com/json/%s", host);
        JSONObject json = this.getJson(url, p -> Extends.eq(p.getString("status"), "success"));
        return new IPAddress(json.getString("query"), json.getString("country"), json.getString("countryCode"), json.getString("city"), json.getString("isp"), String.format("%s %s", json.getString("as"), json.getString("org")));
    }

    IPAddress ipApi(String host) {
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), host)) {
            host = "check";
        }
        String url = String.format("http://api.ipapi.com/%s?access_key=8da5fe816dba52150d4c40ba72705954", host);
        JSONObject json = this.getJson(url, p -> p.getString("country_name") != null);
        return new IPAddress(json.getString("ip"), json.getString("country_name"), json.getString("country_code"), json.getString("city"), null, null);
    }

    IPAddress ipGeo(String ip) {
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), ip)) {
            ip = "";
        } else if (!Sockets.isValidIp(ip)) {
            ip = InetAddress.getByName(ip).getHostAddress();
        }
        String url = String.format("https://api.ipgeolocation.io/ipgeo?apiKey=e96493e9280e4a4fae1b8744ad688272&ip=%s", ip);
        JSONObject json = this.getJson(url, p -> p.getString("country_name") != null);
        return new IPAddress(json.getString("ip"), json.getString("country_name"), json.getString("country_code2"), json.getString("city"), json.getString("isp"), json.getString("organization"));
    }

    IPAddress ipData(String ip) {
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), ip)) {
            ip = "";
        } else if (!Sockets.isValidIp(ip)) {
            ip = InetAddress.getByName(ip).getHostAddress();
        }
        String url = String.format("https://api.ipdata.co/%s?api-key=cbf82d3beb9d0591285d73210d518d99920fb7d50dc2e5a24e9c599a", ip);
        JSONObject json = this.getJson(url, p -> p.getString("country_name") != null);
        String isp = null;
        JSONObject connection = json.getJSONObject("asn");
        if (connection != null) {
            isp = String.format("%s %s", connection.getString("asn"), connection.getString("name"));
        }
        return new IPAddress(json.getString("ip"), json.getString("country_name"), json.getString("country_code"), json.getString("city"), isp, null);
    }

    IPAddress ipWho(String ip) {
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), ip)) {
            ip = "";
        } else if (!Sockets.isValidIp(ip)) {
            ip = InetAddress.getByName(ip).getHostAddress();
        }
        String url = String.format("https://ipwho.is/%s", ip);
        JSONObject json = this.getJson(url, p -> p.getBooleanValue("success"));
        String isp = null;
        String extra = null;
        JSONObject connection = json.getJSONObject("connection");
        if (connection != null) {
            isp = connection.getString("isp");
            extra = connection.getString("org");
        }
        return new IPAddress(json.getString("ip"), json.getString("country"), json.getString("country_code"), json.getString("city"), isp, extra);
    }

    IPAddress ipInfo(String ip) {
        if (Strings.hashEquals(Sockets.getLoopbackHostAddress(), ip)) {
            ip = "";
        } else if (!Sockets.isValidIp(ip)) {
            ip = InetAddress.getByName(ip).getHostAddress();
        }
        String url = String.format("https://ipinfo.io/%s?token=de26227b84b811", ip);
        JSONObject json = this.getJson(url, p -> p.getString("country") != null);
        return new IPAddress(json.getString("ip"), null, json.getString("country"), json.getString("city"), json.getString("org"), null);
    }

    private JSONObject getJson(String url, PredicateFunc<JSONObject> check) {
        HttpClient client = new HttpClient(10000L);
        client.setEnableLog(true);
        String text = client.get(url).toString();
        if (Strings.isEmpty((CharSequence)text)) {
            throw new InvalidException("Empty response from {}", url);
        }
        JSONObject json = Sys.toJsonObject(text);
        if (!check.test(json)) {
            throw new InvalidException("Request:\t{}\nResponse:\t{}", url, text);
        }
        return json;
    }
}

