/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.support;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.rx.core.Cache;
import org.rx.core.Sys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointTracer {
    private static final Logger log = LoggerFactory.getLogger(EndpointTracer.class);
    final Cache<String, SocketAddress> index = Cache.getInstance(Cache.MEMORY_CACHE);

    String key(SocketAddress sa) {
        return Sys.fastCacheKey("EpTrace", sa);
    }

    public void link(Channel inbound, Channel outbound) {
        SocketAddress data = this.index.get(this.key(outbound.localAddress()), k -> inbound.remoteAddress());
    }

    public SocketAddress head(Channel channel) {
        SocketAddress data = (SocketAddress)this.index.get(this.key(channel.remoteAddress()));
        SocketAddress head = data == null ? channel.remoteAddress() : data;
        return head;
    }
}

