/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.support;

import org.rx.net.http.HttpClient;
import org.rx.net.support.ComboIPSearcher;
import org.rx.net.support.IPAddress;

public interface IPSearcher {
    public static final IPSearcher DEFAULT = new ComboIPSearcher();

    public static String godaddyDns(String ssoKey, String domain, String name) {
        return IPSearcher.godaddyDns(ssoKey, domain, name, DEFAULT.currentIp());
    }

    public static String godaddyDns(String ssoKey, String domain, String name, String ip) {
        String url = String.format("https://api.godaddy.com/v1/domains/%s/records/A/%s", domain, name);
        HttpClient client = new HttpClient();
        client.requestHeaders().add("Authorization", (Object)("sso-key " + ssoKey));
        return client.putJson(url, String.format("[\n  {\n    \"data\": \"%s\",\n    \"ttl\": 600\n  }\n]", ip)).toString();
    }

    public String currentIp();

    public IPAddress searchCurrent();

    default public IPAddress search(String host) {
        return this.search(host, false);
    }

    public IPAddress search(String var1, boolean var2);
}

