/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.support;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Objects;
import lombok.NonNull;
import org.rx.net.Sockets;

public class UnresolvedEndpoint
implements Serializable {
    private static final long serialVersionUID = -1870762625355971485L;
    private final String host;
    private final int port;
    private InetSocketAddress cache;

    public static UnresolvedEndpoint valueOf(String value) {
        return new UnresolvedEndpoint(Sockets.parseEndpoint(value));
    }

    public UnresolvedEndpoint(@NonNull InetSocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("socketAddress is marked non-null but is null");
        }
        this.host = socketAddress.getHostString();
        this.port = socketAddress.getPort();
        this.cache = socketAddress;
    }

    public InetSocketAddress socketAddress() {
        if (this.cache == null) {
            this.cache = new InetSocketAddress(this.host, this.port);
        }
        return this.cache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedEndpoint that = (UnresolvedEndpoint)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return String.format("%s:%s", this.host, this.port);
    }

    public UnresolvedEndpoint(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

