/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.rx.core.Arrays;
import org.rx.core.Disposable;
import org.rx.core.Linq;
import org.rx.core.RxConfig;
import org.rx.core.Strings;
import org.rx.exception.InvalidException;
import org.rx.io.CrudFile;
import org.rx.io.Files;
import org.rx.io.IOStream;
import org.rx.net.AuthenticEndpoint;
import org.rx.net.transport.SftpFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpClient
extends Disposable
implements CrudFile<SftpFile> {
    private static final Logger log = LoggerFactory.getLogger(SftpClient.class);
    static final List<String> skipDirectories = Arrays.toList(".", "..");
    final SshClient client = SshClient.setUpDefaultClient();
    final ClientSession session;
    final org.apache.sshd.sftp.client.SftpClient channel;

    public SftpClient(AuthenticEndpoint endpoint) {
        this(endpoint, RxConfig.INSTANCE.getNet().getConnectTimeoutMillis());
    }

    public SftpClient(@NonNull AuthenticEndpoint endpoint, int timeoutMillis) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint is marked non-null but is null");
        }
        this.client.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
        this.client.start();
        this.session = (ClientSession)((ConnectFuture)this.client.connect(endpoint.getUsername(), endpoint.getEndpoint().getHostString(), endpoint.getEndpoint().getPort()).verify((long)timeoutMillis)).getSession();
        this.session.addPasswordIdentity(endpoint.getPassword());
        if (!((AuthFuture)this.session.auth().verify((long)timeoutMillis)).isSuccess()) {
            throw new InvalidException("auth failure", new Object[0]);
        }
        this.channel = SftpClientFactory.instance().createSftpClient(this.session);
    }

    @Override
    protected void freeObjects() throws Throwable {
        this.channel.close();
        this.session.close();
        this.client.close();
    }

    @Override
    public boolean isDirectoryPath(String remotePath) {
        if (Strings.isEmpty((CharSequence)remotePath)) {
            throw new IllegalArgumentException("remotePath");
        }
        char ch = remotePath.charAt(remotePath.length() - 1);
        return ch == '/' || Strings.isEmpty((CharSequence)Files.getExtension((String)remotePath));
    }

    @Override
    public boolean exists(String path) {
        try {
            this.channel.stat(path);
            return true;
        }
        catch (IOException e) {
            log.warn("exists", (Throwable)e);
            return false;
        }
    }

    @Override
    public void delete(String remotePath) {
        if (this.isDirectoryPath(remotePath)) {
            for (SftpFile file : this.listFiles(remotePath, true)) {
                this.channel.remove(file.getPath());
            }
            this.channel.rmdir(remotePath);
            return;
        }
        this.channel.remove(remotePath);
    }

    @Override
    public String createDirectory(String remotePath) {
        String dirPath = this.getDirectoryPath(remotePath);
        if (!this.exists(dirPath)) {
            this.channel.mkdir(dirPath);
        }
        return dirPath;
    }

    @Override
    public void saveFile(String remotePath, InputStream in) {
        try (IOStream stream = IOStream.wrap(Files.getName((String)remotePath), in);){
            this.uploadFile(stream, remotePath);
        }
    }

    @Override
    public Linq<SftpFile> listDirectories(String remotePath, boolean recursive) {
        ArrayList<SftpFile> root = new ArrayList<SftpFile>();
        this.listDirectories(root, recursive, remotePath);
        return Linq.from(root);
    }

    private void listDirectories(List<SftpFile> result, boolean recursive, String directory) {
        for (SftpClient.DirEntry entry : this.channel.readDir(directory)) {
            if (skipDirectories.contains(entry.getFilename()) || !entry.getAttributes().isDirectory()) continue;
            result.add(new SftpFile(Files.concatPath(directory, entry.getFilename()), entry.getFilename(), entry.getLongFilename()));
            if (!recursive) continue;
            this.listDirectories(result, recursive, Files.concatPath(directory, entry.getFilename()));
        }
    }

    @Override
    public Linq<SftpFile> listFiles(String remotePath, boolean recursive) {
        ArrayList<SftpFile> root = new ArrayList<SftpFile>();
        this.listFiles(root, recursive, remotePath);
        return Linq.from(root);
    }

    private void listFiles(List<SftpFile> result, boolean recursive, String directory) {
        for (SftpClient.DirEntry entry : this.channel.readEntries(directory)) {
            if (skipDirectories.contains(entry.getFilename())) continue;
            if (entry.getAttributes().isDirectory()) {
                if (!recursive) continue;
                this.listFiles(result, recursive, Files.concatPath(directory, entry.getFilename()));
                continue;
            }
            result.add(new SftpFile(Files.concatPath(directory, entry.getFilename()), entry.getFilename(), entry.getLongFilename()));
        }
    }

    public void uploadFile(String localPath, String remotePath) {
        this.uploadFile(IOStream.wrap(localPath), remotePath);
    }

    public void uploadFile(@NonNull IOStream stream, @NonNull String remotePath) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (remotePath == null) {
            throw new NullPointerException("remotePath is marked non-null but is null");
        }
        if (Files.isDirectory(remotePath)) {
            if (Strings.isEmpty((CharSequence)stream.getName())) {
                throw new InvalidException("Empty stream name", new Object[0]);
            }
            remotePath = this.padDirectoryPath(remotePath) + stream.getName();
        }
        this.createDirectory(remotePath);
        stream.read(this.channel.write(remotePath));
    }

    public void downloadFile(String remotePath, String localPath) {
        Files.createDirectory(localPath);
        this.downloadFile(remotePath, IOStream.wrap(localPath));
    }

    public void downloadFile(@NonNull String remotePath, @NonNull IOStream stream) {
        if (remotePath == null) {
            throw new NullPointerException("remotePath is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        stream.write(this.channel.read(remotePath));
    }
}

