/*
 * Decompiled with CFR 0.152.
 */
package org.rx.net.transport;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.rx.core.Delegate;
import org.rx.core.EventPublisher;
import org.rx.core.NEventArgs;
import org.rx.net.transport.ClientDisconnectedException;

public interface TcpClient
extends AutoCloseable,
EventPublisher<TcpClient> {
    public boolean isConnected();

    public InetSocketAddress getRemoteEndpoint();

    public void connect(InetSocketAddress var1) throws TimeoutException;

    public Future<Void> connectAsync(InetSocketAddress var1);

    public void send(Serializable var1);

    public Delegate<TcpClient, NEventArgs<Serializable>> onReceive();

    public Channel getChannel();

    default public boolean hasAttr(String name) {
        return this.getChannel().hasAttr(AttributeKey.valueOf((String)name));
    }

    default public <T> T attr(String name) {
        return (T)this.getChannel().attr(AttributeKey.valueOf((String)name)).get();
    }

    default public <T> void attr(String name, T val) {
        if (!this.isConnected()) {
            throw new ClientDisconnectedException("");
        }
        this.getChannel().attr(AttributeKey.valueOf((String)name)).set(val);
    }
}

