/*
 * Decompiled with CFR 0.152.
 */
package org.rx.spring;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.rx.bean.FlagsEnum;
import org.rx.bean.ProceedEventArgs;
import org.rx.core.Arrays;
import org.rx.core.Delegate;
import org.rx.core.EventPublisher;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.Sys;
import org.rx.core.ThreadPool;
import org.rx.exception.TraceHandler;

public abstract class BaseInterceptor
implements EventPublisher<BaseInterceptor> {
    static final int MAX_FIELD_SIZE = 4096;
    static final FastThreadLocal<Boolean> idempotent = new FastThreadLocal();
    public final Delegate<BaseInterceptor, ProceedEventArgs> onProcessing = Delegate.create();
    public final Delegate<BaseInterceptor, ProceedEventArgs> onProceed = Delegate.create();
    public final Delegate<BaseInterceptor, ProceedEventArgs> onError = Delegate.create();

    @Override
    public FlagsEnum<EventPublisher.EventFlags> eventFlags() {
        return EventPublisher.EventFlags.DYNAMIC_ATTACH.flags(new EventPublisher.EventFlags[]{EventPublisher.EventFlags.QUIETLY});
    }

    protected final void enableTrace(String traceName) {
        if (traceName == null) {
            traceName = "rx-traceId";
        }
        RxConfig.ThreadPoolConfig conf = RxConfig.INSTANCE.getThreadPool();
        conf.setTraceName(traceName);
        ThreadPool.onTraceIdChanged.first((s, e) -> Sys.logCtx(conf.getTraceName(), e.getValue()));
    }

    protected String startTrace(JoinPoint joinPoint, String parentTraceId) {
        return ThreadPool.startTrace(parentTraceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        if (BooleanUtils.isTrue((Boolean)((Boolean)idempotent.get()))) {
            return joinPoint.proceed();
        }
        idempotent.set((Object)Boolean.TRUE);
        String tn = RxConfig.INSTANCE.getThreadPool().getTraceName();
        if (tn != null) {
            Sys.logCtxIfAbsent(tn, this.startTrace((JoinPoint)joinPoint, null));
        }
        try {
            Signature signature = joinPoint.getSignature();
            MethodSignature methodSignature = Extends.as(signature, MethodSignature.class);
            boolean isVoid = methodSignature == null || methodSignature.getReturnType().equals(Void.TYPE);
            ProceedEventArgs eventArgs = new ProceedEventArgs(signature.getDeclaringType(), joinPoint.getArgs(), isVoid);
            this.raiseEvent(this.onProcessing, eventArgs);
            if (eventArgs.isCancel()) {
                Object object = joinPoint.proceed();
                return object;
            }
            RxConfig conf = RxConfig.INSTANCE;
            eventArgs.setLogStrategy(conf.getLogStrategy());
            eventArgs.setLogTypeWhitelist(conf.getLogTypeWhitelist());
            try {
                eventArgs.proceed(() -> joinPoint.proceed(eventArgs.getParameters()));
                TraceHandler.INSTANCE.saveTrace(eventArgs.getDeclaringType(), signature.getName(), eventArgs.getParameters(), eventArgs.getElapsedNanos() / 1000L);
            }
            catch (Throwable e) {
                eventArgs.setError(e);
                this.raiseEvent(this.onError, eventArgs);
                if (eventArgs.getError() != null) {
                    throw eventArgs.getError();
                }
                eventArgs.setError(e);
            }
            finally {
                this.raiseEvent(this.onProceed, eventArgs);
                this.onLog(signature, eventArgs);
            }
            Object object = eventArgs.getReturnValue();
            return object;
        }
        finally {
            ThreadPool.endTrace();
            Sys.clearLogCtx();
            idempotent.remove();
        }
    }

    protected void onLog(Signature signature, ProceedEventArgs eventArgs) {
        Sys.log(eventArgs, msg -> {
            msg.appendLine("Call:\t%s", signature.getName());
            msg.appendLine("Parameters:\t%s", this.jsonString(signature, eventArgs.getParameters())).appendLine("ReturnValue:\t%s\tElapsed=%s", this.jsonString(signature, eventArgs.getReturnValue()), Sys.formatNanosElapsed(eventArgs.getElapsedNanos()));
            if (eventArgs.getError() != null) {
                msg.appendLine("Error:\t%s", eventArgs.getError().getMessage());
            }
        });
    }

    private String jsonString(Signature signature, Object ... args) {
        if (Arrays.isEmpty((Object[])args)) {
            return "{}";
        }
        List<Object> list = Linq.from(args).select(p -> this.shortArg(signature, p)).toList();
        return Sys.toJsonString(list.size() == 1 ? list.get(0) : list);
    }

    protected Object shortArg(Signature signature, Object arg) {
        String s;
        byte[] b;
        if (arg instanceof byte[] && (b = (byte[])arg).length > 4096) {
            return "[BigBytes]";
        }
        if (arg instanceof String && (s = (String)arg).length() > 4096) {
            return "[BigString]";
        }
        return arg;
    }

    protected final Object defaultValue(Signature signature) {
        MethodSignature methodSignature = Extends.as(signature, MethodSignature.class);
        if (methodSignature == null) {
            return null;
        }
        return Reflects.defaultValue(methodSignature.getReturnType());
    }
}

