/*
 * Decompiled with CFR 0.152.
 */
package org.rx.spring;

import java.lang.reflect.Executable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.rx.annotation.EnableTrace;
import org.rx.bean.ProceedEventArgs;
import org.rx.bean.Tuple;
import org.rx.core.Arrays;
import org.rx.core.Extends;
import org.rx.core.RxConfig;
import org.rx.core.Sys;
import org.rx.exception.ApplicationException;
import org.rx.exception.TraceHandler;
import org.rx.net.http.HttpClient;
import org.rx.spring.BaseInterceptor;
import org.rx.spring.IRequireSignIn;
import org.rx.spring.NotSignInException;
import org.rx.spring.SpringContext;
import org.rx.util.Servlets;
import org.rx.util.Validator;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

public class Interceptors {

    @Aspect
    @Component
    public static class TraceInterceptor
    extends BaseInterceptor {
        public void setTraceName(String traceName) {
            super.enableTrace(traceName);
        }

        @Override
        @Around(value="@annotation(org.rx.annotation.EnableTrace) || @within(org.rx.annotation.EnableTrace)")
        public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
            Signature signature = joinPoint.getSignature();
            if (signature instanceof ConstructorSignature) {
                ConstructorSignature cs = (ConstructorSignature)signature;
                if (this.doValidate(cs.getConstructor())) {
                    Validator.validateConstructor(cs.getConstructor(), joinPoint.getArgs(), joinPoint.getTarget());
                }
                return super.doAround(joinPoint);
            }
            MethodSignature ms = (MethodSignature)signature;
            if (this.doValidate(ms.getMethod())) {
                return Validator.validateMethod(ms.getMethod(), joinPoint.getTarget(), joinPoint.getArgs(), () -> super.doAround(joinPoint));
            }
            return super.doAround(joinPoint);
        }

        @Override
        protected void onLog(Signature signature, ProceedEventArgs eventArgs) {
            Executable r = signature instanceof ConstructorSignature ? ((ConstructorSignature)signature).getConstructor() : ((MethodSignature)signature).getMethod();
            EnableTrace a = r.getAnnotation(EnableTrace.class);
            if (a == null || a.doLog()) {
                super.onLog(signature, eventArgs);
            }
        }

        protected boolean doValidate(Executable r) {
            EnableTrace a = r.getAnnotation(EnableTrace.class);
            return a != null && a.doValidate();
        }
    }

    @Component
    @ControllerAdvice
    public static class ControllerInterceptor
    extends BaseInterceptor {
        final List<String> skipMethods = new CopyOnWriteArrayList<String>(Arrays.toList("setServletRequest", "setServletResponse", "isSignIn"));

        protected Object methodAround(ProceedingJoinPoint joinPoint, Tuple<HttpServletRequest, HttpServletResponse> httpEnv) {
            Sys.logCtx("url", ((HttpServletRequest)httpEnv.left).getRequestURL().toString());
            return super.doAround(joinPoint);
        }

        @Override
        protected Object shortArg(Signature signature, Object arg) {
            if (arg instanceof MultipartFile) {
                return "[MultipartFile]";
            }
            return super.shortArg(signature, arg);
        }

        @Override
        protected String startTrace(JoinPoint joinPoint, String parentTraceId) {
            Tuple<HttpServletRequest, HttpServletResponse> httpEnv = this.httpEnv();
            if (httpEnv == null) {
                return super.startTrace(joinPoint, parentTraceId);
            }
            String tn = RxConfig.INSTANCE.getThreadPool().getTraceName();
            if (parentTraceId == null) {
                parentTraceId = ((HttpServletRequest)httpEnv.left).getHeader(tn);
            }
            String tid = super.startTrace(joinPoint, parentTraceId);
            ((HttpServletResponse)httpEnv.right).setHeader(tn, tid);
            return tid;
        }

        @Override
        public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
            String fu;
            Tuple<HttpServletRequest, HttpServletResponse> httpEnv = this.httpEnv();
            if (httpEnv == null) {
                return super.doAround(joinPoint);
            }
            Signature signature = joinPoint.getSignature();
            MethodSignature ms = Extends.as(signature, MethodSignature.class);
            if (ms == null || this.skipMethods.contains(signature.getName())) {
                return joinPoint.proceed();
            }
            Map<String, String> fts = RxConfig.INSTANCE.getHttpForwards().get(ms.getDeclaringType());
            if (fts != null && (fu = fts.get(ms.getName())) != null) {
                Sys.logCtx("fu", fu);
                new HttpClient().forward((HttpServletRequest)httpEnv.left, (HttpServletResponse)httpEnv.right, fu);
                return null;
            }
            IRequireSignIn requireSignIn = Extends.as(joinPoint.getTarget(), IRequireSignIn.class);
            if (requireSignIn != null && !requireSignIn.isSignIn(ms.getMethod(), joinPoint.getArgs())) {
                throw new NotSignInException();
            }
            return this.methodAround(joinPoint, httpEnv);
        }

        protected Tuple<HttpServletRequest, HttpServletResponse> httpEnv() {
            try {
                return Servlets.currentRequest();
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }

        @ExceptionHandler(value={Exception.class})
        @ResponseStatus(value=HttpStatus.OK)
        @ResponseBody
        public Object onException(Exception e, HttpServletRequest request) {
            FieldError fieldError;
            TraceHandler.INSTANCE.log(request.getRequestURL().toString(), e);
            String msg = null;
            if (e instanceof MethodArgumentNotValidException && (fieldError = ((MethodArgumentNotValidException)e).getBindingResult().getFieldError()) != null) {
                msg = String.format("Field '%s' %s", fieldError.getField(), fieldError.getDefaultMessage());
            }
            if (msg == null) {
                msg = ApplicationException.getMessage(e);
            }
            if (SpringContext.controllerExceptionHandler != null) {
                return SpringContext.controllerExceptionHandler.invoke(e, msg);
            }
            return new ResponseEntity((Object)msg, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

