/*
 * Decompiled with CFR 0.152.
 */
package org.rx.spring;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.TypeReference;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.rx.annotation.Subscribe;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.NtpClock;
import org.rx.core.ObjectChangeTracker;
import org.rx.core.ObjectChangedEvent;
import org.rx.core.Reflects;
import org.rx.core.RxConfig;
import org.rx.core.ShellCommand;
import org.rx.core.StringBuilder;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.core.Tasks;
import org.rx.exception.ExceptionLevel;
import org.rx.exception.TraceHandler;
import org.rx.io.Bytes;
import org.rx.io.IOStream;
import org.rx.net.NetEventWait;
import org.rx.net.Sockets;
import org.rx.net.socks.SocksContext;
import org.rx.spring.SpringContext;
import org.rx.util.BeanMapFlag;
import org.rx.util.BeanMapper;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"mx"})
public class MxController {
    @RequestMapping(value={"httpSignal"})
    public void httpSignal(String multicast, String group, Integer mcId) {
        NetEventWait.multicastLocal(Sockets.parseEndpoint(multicast), group, (int)Extends.ifNull(mcId, 0));
    }

    @RequestMapping(value={"queryTraces"})
    public Map<String, Object> queryTraces(Boolean newest, String level, Boolean methodOccurMost, String methodNamePrefix, String metricsName, Integer take, HttpServletRequest request) {
        if (!this.check(request)) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(3);
        ExceptionLevel el = null;
        if (!Strings.isBlank((CharSequence)level)) {
            el = ExceptionLevel.valueOf(level);
        }
        result.put("errorTraces", TraceHandler.INSTANCE.queryTraces(newest, el, take));
        result.put("methodTraces", Linq.from(TraceHandler.INSTANCE.queryTraces(methodOccurMost, methodNamePrefix, take)).select(p -> {
            JSONObject t = Sys.toJsonObject(p);
            t.remove("elapsedMicros");
            t.put("elapsed", Sys.formatNanosElapsed(p.getElapsedMicros(), 1));
            return t;
        }));
        result.put("metrics", TraceHandler.INSTANCE.queryMetrics(metricsName, take));
        return result;
    }

    @RequestMapping(value={"health"})
    public Object health(HttpServletRequest request, HttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        String x = request.getParameter("x");
        if (!this.check(request) || x == null) {
            StringBuilder buf = new StringBuilder();
            buf.appendLine("%s %s", request.getMethod(), request.getRequestURL().toString());
            for (String n : Collections.list(request.getHeaderNames())) {
                buf.appendLine("%s: %s", n, request.getHeader(n));
            }
            ServletInputStream inStream = request.getInputStream();
            if (inStream != null) {
                buf.appendLine(IOStream.readString((InputStream)inStream, StandardCharsets.UTF_8));
            }
            TraceHandler.INSTANCE.log("rx replay {}", buf);
            return new ResponseEntity((Object)buf, (MultiValueMap)headers, HttpStatus.OK);
        }
        String rt = "1";
        try {
            switch (Integer.parseInt(x)) {
                case 1: {
                    Sys.diagnosticMx.setVMOption(request.getParameter("k"), request.getParameter("v"));
                    return "1";
                }
                case 2: {
                    boolean enable = Boolean.parseBoolean(request.getParameter("v"));
                    Sys.threadMx.setThreadContentionMonitoringEnabled(enable);
                    Sys.threadMx.setThreadCpuTimeEnabled(enable);
                    return "1";
                }
                case 3: {
                    RxConfig target;
                    String type = request.getParameter("type");
                    String jsonVal = request.getParameter("jsonVal");
                    Object source = null;
                    if (!Strings.isBlank((CharSequence)type)) {
                        Class<?> clazz = Class.forName(type);
                        target = SpringContext.getBean(clazz);
                        if (target == null) {
                            return null;
                        }
                        if (jsonVal != null) {
                            source = Sys.fromJson(jsonVal, clazz);
                        }
                    } else {
                        if (jsonVal != null) {
                            source = Sys.fromJson(jsonVal, new TypeReference<RxConfig>(){}.getType());
                        }
                        target = RxConfig.INSTANCE;
                    }
                    return source != null ? BeanMapper.DEFAULT.map(source, target, BeanMapFlag.SKIP_NULL.flags()) : target;
                }
                case 4: {
                    return this.invoke(request);
                }
                case 10: {
                    return Linq.from(InetAddress.getAllByName(request.getParameter("host"))).select(p -> p.getHostAddress()).toArray();
                }
                case 11: {
                    return new ResponseEntity(this.exec(request), (MultiValueMap)headers, HttpStatus.OK);
                }
                case 12: {
                    SocksContext.omegax(Reflects.convertQuietly(request.getParameter("p"), Integer.class, 22));
                    return "1";
                }
                case 13: {
                    Class<?> ft = Class.forName(request.getParameter("ft"));
                    String fn = request.getParameter("fn");
                    String fu = request.getParameter("fu");
                    Map<Class<?>, Map<String, String>> fms = RxConfig.INSTANCE.getHttpForwards();
                    if (fu == null) {
                        Map<String, String> fts = fms.get(ft);
                        if (fts != null) {
                            fts.remove(fn);
                        }
                    } else {
                        fms.computeIfAbsent(ft, k -> new ConcurrentHashMap(8)).put(fn, fu);
                    }
                    return fms;
                }
            }
            return this.svrState(request);
        }
        catch (Throwable e) {
            return new ResponseEntity((Object)String.format("%s\n%s", e, ExceptionUtils.getStackTrace((Throwable)e)), (MultiValueMap)headers, HttpStatus.OK);
        }
    }

    Object invoke(HttpServletRequest request) {
        Map<String, Object> params = this.getParams(request);
        Class<?> kls = Class.forName((String)params.get("bean"));
        Object bean = SpringContext.getBean(kls);
        Method method = Reflects.getMethodMap(kls).get((String)params.get("method")).first();
        List args = (List)params.get("args");
        Class[] parameterTypes = method.getParameterTypes();
        Object[] a = Linq.from(method.getGenericParameterTypes()).select((p, i) -> {
            Object o = args.get(i);
            try {
                return Sys.fromJson(o, p);
            }
            catch (Exception e) {
                return Reflects.changeType(o, parameterTypes[i]);
            }
        }).toArray();
        return Reflects.invokeMethod(method, bean, a);
    }

    Object exec(HttpServletRequest request) {
        Map<String, Object> params = this.getParams(request);
        StringBuilder echo = new StringBuilder();
        ShellCommand cmd = new ShellCommand((String)params.get("cmd"), (String)params.get("workspace"));
        cmd.onPrintOut.combine((s, e) -> echo.append(e.toString()));
        cmd.start().waitFor(30000L);
        return echo.toString();
    }

    Map<String, Object> getParams(HttpServletRequest request) {
        String b = request.getParameter("body");
        if (b == null) {
            b = IOStream.readString((InputStream)request.getInputStream(), StandardCharsets.UTF_8);
        }
        return Sys.toJsonObject(b);
    }

    Map<String, Object> svrState(HttpServletRequest request) {
        LinkedHashMap<String, Object> j = new LinkedHashMap<String, Object>();
        j.put("jarFile", Sys.getJarFile(this));
        j.put("inputArguments", ManagementFactory.getRuntimeMXBean().getInputArguments());
        try {
            Sys.diagnosticMx.setVMOption("UnlockCommercialFeatures", Boolean.TRUE.toString());
        }
        catch (Exception e) {
            j.put("UnlockCommercialFeatures", e.toString());
        }
        j.put("vmOptions", Sys.diagnosticMx.getDiagnosticOptions());
        j.put("sysProperties", Linq.from(System.getProperties().entrySet()).toMap());
        j.put("sysEnv", System.getenv());
        Sys.Info info = Sys.mxInfo();
        JSONObject infoJson = Sys.toJsonObject(info);
        infoJson.put((Object)"usedPhysicalMemory", (Object)Bytes.readableByteSize(info.getUsedPhysicalMemory()));
        infoJson.put((Object)"freePhysicalMemory", (Object)Bytes.readableByteSize(info.getFreePhysicalMemory()));
        infoJson.put((Object)"totalPhysicalMemory", (Object)Bytes.readableByteSize(info.getTotalPhysicalMemory()));
        JSONObject summedDisk = infoJson.getJSONObject("summedDisk");
        summedDisk.put((Object)"usedSpace", (Object)Bytes.readableByteSize(info.getSummedDisk().getUsedSpace()));
        summedDisk.put((Object)"freeSpace", (Object)Bytes.readableByteSize(info.getSummedDisk().getFreeSpace()));
        summedDisk.put((Object)"totalSpace", (Object)Bytes.readableByteSize(info.getSummedDisk().getTotalSpace()));
        JSONArray disks = infoJson.getJSONArray("disks");
        int i = 0;
        for (Sys.DiskInfo disk : info.getDisks()) {
            JSONObject diskJson = disks.getJSONObject(i);
            diskJson.put((Object)"usedSpace", (Object)Bytes.readableByteSize(disk.getUsedSpace()));
            diskJson.put((Object)"freeSpace", (Object)Bytes.readableByteSize(disk.getFreeSpace()));
            diskJson.put((Object)"totalSpace", (Object)Bytes.readableByteSize(disk.getTotalSpace()));
            ++i;
        }
        j.put("sysInfo", infoJson);
        j.put("deadlockedThreads", Sys.findDeadlockedThreads());
        Linq<Sys.ThreadInfo> allThreads = Sys.getAllThreads();
        int take = Reflects.convertQuietly(request.getParameter("take"), Integer.class, 5);
        j.put("topUserTimeThreads", allThreads.orderByDescending(Sys.ThreadInfo::getUserNanos).take(take).select(Sys.ThreadInfo::toString));
        j.put("topCpuTimeThreads", allThreads.orderByDescending(Sys.ThreadInfo::getCpuNanos).take(take).select(Sys.ThreadInfo::toString));
        j.put("topBlockedTimeThreads", allThreads.orderByDescending(p -> p.getThread().getBlockedTime()).take(take).select(Sys.ThreadInfo::toString));
        j.put("topWaitedTimeThreads", allThreads.orderByDescending(p -> p.getThread().getWaitedTime()).take(take).select(Sys.ThreadInfo::toString));
        j.put("ntpOffset", Reflects.readStaticField(NtpClock.class, "offset"));
        j.put("rxConfig", RxConfig.INSTANCE);
        j.put("requestHeaders", Linq.from(Collections.list(request.getHeaderNames())).select(p -> String.format("%s: %s", p, String.join((CharSequence)"; ", Collections.list(request.getHeaders(p))))));
        j.putAll(this.queryTraces(null, null, null, null, null, take, request));
        return j;
    }

    boolean check(HttpServletRequest request) {
        return Extends.eq(request.getHeader("app.mxpwd".replace(".", "-")), RxConfig.INSTANCE.getMxpwd());
    }

    @PostConstruct
    public void init() {
        Class.forName(Sys.class.getName());
        ObjectChangeTracker.DEFAULT.register(this);
    }

    @Subscribe(topicClass=RxConfig.class)
    void onChanged(ObjectChangedEvent event) {
        Tasks.setTimeout(() -> {
            String omega = ((RxConfig)event.source()).getOmega();
            if (omega != null) {
                SocksContext.omega(omega, null);
            }
        }, 60000L);
    }
}

