/*
 * Decompiled with CFR 0.152.
 */
package org.rx.spring;

import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.rx.core.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.util.ContentCachingRequestWrapper;

@Order(value=-2147483648)
@WebFilter(urlPatterns={"/*"})
public class MxWebFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MxWebFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (Strings.startsWithIgnoreCase((CharSequence)servletRequest.getContentType(), (CharSequence)HttpHeaderValues.APPLICATION_JSON) && !(servletRequest instanceof ContentCachingRequestWrapper)) {
            servletRequest = new ContentCachingRequestWrapper((HttpServletRequest)servletRequest);
            log.info("MxWebFilter exchange ContentCachingRequest");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

