/*
 * Decompiled with CFR 0.152.
 */
package org.rx.spring;

import java.io.File;
import javax.validation.Validation;
import javax.validation.Validator;
import org.rx.bean.Decimal;
import org.rx.core.Reflects;
import org.rx.net.AuthenticEndpoint;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true, exposeProxy=true)
public class SpringConfig {
    @Bean
    public Validator validator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    @Component
    @ConfigurationPropertiesBinding
    public static class ClassConverter
    implements Converter<String, Class<?>> {
        public Class<?> convert(String s) {
            return Reflects.loadClass(s, false);
        }
    }

    @Component
    @ConfigurationPropertiesBinding
    public static class FileConverter
    implements Converter<String, File> {
        public File convert(String s) {
            return new File(s);
        }
    }

    @Component
    @ConfigurationPropertiesBinding
    public static class AuthenticEndpointConverter
    implements Converter<String, AuthenticEndpoint> {
        public AuthenticEndpoint convert(String s) {
            return AuthenticEndpoint.valueOf(s);
        }
    }

    @Component
    @ConfigurationPropertiesBinding
    public static class DecimalConverter
    implements Converter<Object, Decimal> {
        public Decimal convert(Object s) {
            return Decimal.valueOf(s.toString());
        }
    }
}

