/*
 * Decompiled with CFR 0.152.
 */
package org.rx.spring;

import java.util.Map;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Strings;
import org.rx.util.function.TripleFunc;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    static TripleFunc<Throwable, String, Object> controllerExceptionHandler;

    public static boolean isInitiated() {
        return applicationContext != null;
    }

    public static ApplicationContext getApplicationContext() {
        Extends.require(applicationContext);
        return applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)SpringContext.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        Map beanMaps = SpringContext.getApplicationContext().getBeansOfType(clazz);
        return !beanMaps.isEmpty() ? (T)beanMaps.values().iterator().next() : null;
    }

    public static String[] fromYamlArray(String yamlArray) {
        if (Strings.isEmpty((CharSequence)yamlArray)) {
            return new String[0];
        }
        return Linq.from(Strings.split(yamlArray, "\n")).select(p -> {
            if (p.startsWith("- ")) {
                return p.substring(2);
            }
            return p;
        }).toArray();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContext.applicationContext = applicationContext;
    }

    public static void setControllerExceptionHandler(TripleFunc<Throwable, String, Object> controllerExceptionHandler) {
        SpringContext.controllerExceptionHandler = controllerExceptionHandler;
    }
}

