/*
 * Decompiled with CFR 0.152.
 */
package org.rx.third.apache.ntp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.rx.third.apache.ntp.DatagramSocketClient;
import org.rx.third.apache.ntp.NtpV3Impl;
import org.rx.third.apache.ntp.NtpV3Packet;
import org.rx.third.apache.ntp.TimeInfo;
import org.rx.third.apache.ntp.TimeStamp;

public final class NTPUDPClient
extends DatagramSocketClient {
    public static final int DEFAULT_PORT = 123;
    private int version = 3;

    public TimeInfo getTime(InetAddress host, int port) throws IOException {
        if (!this.isOpen()) {
            this.open();
        }
        NtpV3Impl message = new NtpV3Impl();
        message.setMode(3);
        message.setVersion(this.version);
        DatagramPacket sendPacket = message.getDatagramPacket();
        sendPacket.setAddress(host);
        sendPacket.setPort(port);
        NtpV3Impl recMessage = new NtpV3Impl();
        DatagramPacket receivePacket = recMessage.getDatagramPacket();
        TimeStamp now = TimeStamp.getCurrentTime();
        message.setTransmitTime(now);
        this._socket_.send(sendPacket);
        this._socket_.receive(receivePacket);
        long returnTimeMillis = System.currentTimeMillis();
        return new TimeInfo((NtpV3Packet)recMessage, returnTimeMillis, false);
    }

    public TimeInfo getTime(InetAddress host) throws IOException {
        return this.getTime(host, 123);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

