/*
 * Decompiled with CFR 0.152.
 */
package org.rx.third.open;

import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.rx.third.open.CrcModel;

public final class CRC {
    private final CrcModel model;
    long crc;
    private int length;

    CRC(CRC crc) {
        Objects.requireNonNull(crc, "CRC::new - crc is null");
        this.model = crc.model;
        this.crc = crc.crc;
        this.length = crc.length;
    }

    CRC(CrcModel model, long crc, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("CRC::new - length less than 0");
        }
        this.model = Objects.requireNonNull(model, "CRC::new - model is null");
        this.crc = crc;
        this.length = length;
    }

    CRC(CrcModel model) {
        this(model, model.init, 0);
    }

    @Generated
    public CRC copy() {
        return new CRC(this);
    }

    public long getCrc() {
        return this.length == 0 ? this.model.getInit() : this.crc;
    }

    public CRC update(byte[] buff, int offset, int len) {
        if (buff != null && len > 0) {
            if (this.length == 0) {
                this.crc = this.model.init;
            }
            this.crc = this.model.crcBytewise(this.crc, buff, offset, len);
            this.length += len;
        }
        return this;
    }

    public CRC update(byte[] buff, int len) {
        return this.update(buff, 0, len);
    }

    public CRC update(byte[] buff) {
        return this.update(buff, buff.length);
    }

    public long combine(long crc2, int len2) {
        return CrcModel.crc_general_combine(this.length == 0 ? this.model.init : this.getCrc(), crc2, len2, this.model.getWidth(), this.model.getInit(), this.model.getPoly(), this.model.getXorot(), this.model.isRefot());
    }

    public CRC combine(CRC crc) {
        Optional.ofNullable(crc).filter(c -> c.length > 0).ifPresent(c -> {
            this.crc = this.combine(c.getCrc(), c.length);
            this.length += c.length;
        });
        return this;
    }

    public String toString() {
        return this.getModel().toString() + "[crc:" + this.getCrc() + ",len:" + this.getLength() + "]";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRC)) {
            return false;
        }
        CRC other = (CRC)o;
        if (this.getCrc() != other.getCrc()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        CrcModel this$model = this.getModel();
        CrcModel other$model = other.getModel();
        return !(this$model == null ? other$model != null : !((Object)this$model).equals(other$model));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $crc = this.getCrc();
        result = result * 59 + (int)($crc >>> 32 ^ $crc);
        result = result * 59 + this.getLength();
        CrcModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        return result;
    }

    public CrcModel getModel() {
        return this.model;
    }

    public int getLength() {
        return this.length;
    }
}

