/*
 * Decompiled with CFR 0.152.
 */
package org.rx.third.open;

import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.rx.third.open.CRC;
import org.rx.third.open.CrcModel;

public class CrcDescription {
    protected final int width;
    protected final long poly;
    protected final long init;
    protected final boolean refin;
    protected final boolean refot;
    protected final long xorot;
    protected volatile long[] table_byte = null;

    public CrcDescription(CrcDescription model) {
        this(Objects.requireNonNull(model, "CRC_model_d::new - model is null").getWidth(), model.getPoly(), model.getInit(), model.isRefin(), model.isRefot(), model.getXorot());
    }

    @Generated
    public String toString() {
        return "CRC-" + this.getWidth() + "/P" + Long.toHexString(this.poly).toUpperCase() + "_I" + (this.init == 0L ? "0" : Long.toHexString(this.init).toUpperCase()) + (this.refin ? "_RI" : "") + (this.refot ? "_RO" : "") + (this.xorot == 0L ? "" : "_X" + Long.toHexString(this.xorot).toUpperCase());
    }

    public CRC getCRC() {
        return CrcModel.construct(this).getCRC();
    }

    public CRC getCRC(long crc, int len) {
        return CrcModel.construct(this).getCRC(crc, len);
    }

    public CrcDescription(int width, long poly, long init, boolean refin, boolean refot, long xorot) {
        this.width = width;
        this.poly = poly;
        this.init = init;
        this.refin = refin;
        this.refot = refot;
        this.xorot = xorot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrcDescription)) {
            return false;
        }
        CrcDescription other = (CrcDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getPoly() != other.getPoly()) {
            return false;
        }
        if (this.getInit() != other.getInit()) {
            return false;
        }
        if (this.isRefin() != other.isRefin()) {
            return false;
        }
        if (this.isRefot() != other.isRefot()) {
            return false;
        }
        if (this.getXorot() != other.getXorot()) {
            return false;
        }
        return Arrays.equals(this.table_byte, other.table_byte);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CrcDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        long $poly = this.getPoly();
        result = result * 59 + (int)($poly >>> 32 ^ $poly);
        long $init = this.getInit();
        result = result * 59 + (int)($init >>> 32 ^ $init);
        result = result * 59 + (this.isRefin() ? 79 : 97);
        result = result * 59 + (this.isRefot() ? 79 : 97);
        long $xorot = this.getXorot();
        result = result * 59 + (int)($xorot >>> 32 ^ $xorot);
        result = result * 59 + Arrays.hashCode(this.table_byte);
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public long getPoly() {
        return this.poly;
    }

    public long getInit() {
        return this.init;
    }

    public boolean isRefin() {
        return this.refin;
    }

    public boolean isRefot() {
        return this.refot;
    }

    public long getXorot() {
        return this.xorot;
    }
}

