/*
 * Decompiled with CFR 0.152.
 */
package org.rx.third.open;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;
import org.rx.third.open.CRC;
import org.rx.third.open.CrcDescription;

public class CrcModel
extends CrcDescription {
    public static final String CHECK_BUFF = "123456789";
    public final String name;
    public final Long check;
    private final CrcDescription crcDescription;
    private static final List<CrcModel> models = new ArrayList<CrcModel>();
    public static final CrcModel CRC3_GSM = new CrcModel("CRC-3/GSM", 3, 3L, 0L, false, false, 7L, 4L);
    public static final CrcModel CRC3_ROHC = new CrcModel("CRC-3/ROHC", 3, 3L, 7L, true, true, 0L, 6L);
    public static final CrcModel CRC4_INTERLAKEN = new CrcModel("CRC-4/INTERLAKEN", 4, 3L, 15L, false, false, 15L, 11L);
    public static final CrcModel CRC4_G_704 = new CrcModel("CRC-4/G-704", 4, 3L, 0L, true, true, 0L, 7L);
    public static final CrcModel CRC4_ITU = CrcModel.alias("CRC-4/ITU", CRC4_G_704);
    public static final CrcModel CRC5_EPC_C1G2 = new CrcModel("CRC-5/EPC-C1G2", 5, 9L, 9L, false, false, 0L, 0L);
    public static final CrcModel CRC5_EPC = CrcModel.alias("CRC-5/EPC", CRC5_EPC_C1G2);
    public static final CrcModel CRC5_G_704 = new CrcModel("CCRC-5/G-704", 5, 21L, 0L, true, true, 0L, 7L);
    public static final CrcModel CRC5_ITU = CrcModel.alias("CRC-5/ITU", CRC5_G_704);
    public static final CrcModel CRC5_USB = new CrcModel("CRC-5/USB", 5, 5L, 31L, true, true, 31L, 25L);
    public static final CrcModel CRC6_CDMA2000_A = new CrcModel("CRC-6/CDMA2000-A", 6, 39L, 63L, false, false, 0L, 13L);
    public static final CrcModel CRC6_CDMA2000_B = new CrcModel("CRC-6/CDMA2000-B", 6, 7L, 63L, false, false, 0L, 59L);
    public static final CrcModel CRC6_DARC = new CrcModel("CRC-6/DARC", 6, 25L, 0L, true, true, 0L, 38L);
    public static final CrcModel CRC6_GSM = new CrcModel("CRC-6/GSM", 6, 47L, 0L, false, false, 63L, 19L);
    public static final CrcModel CRC6_G_704 = new CrcModel("CRC-6/G-704", 6, 3L, 0L, true, true, 0L, 6L);
    public static final CrcModel CRC6_ITU = CrcModel.alias("CRC-6/ITU", CRC6_G_704);
    public static final CrcModel CRC7_MMC = new CrcModel("CRC-7/MMC", 7, 9L, 0L, false, false, 0L, 117L);
    public static final CrcModel CRC7 = CrcModel.alias("CRC-7", CRC7_MMC);
    public static final CrcModel CRC7_ROHC = new CrcModel("CRC-7/ROHC", 7, 79L, 127L, true, true, 0L, 83L);
    public static final CrcModel CRC7_UMTS = new CrcModel("CRC-7/UMTS", 7, 69L, 0L, false, false, 0L, 97L);
    public static final CrcModel CRC8_SMBUS = new CrcModel("CRC-8/SMBUS", 8, 7L, 0L, false, false, 0L, 244L);
    public static final CrcModel CRC8 = CrcModel.alias("CRC-8", CRC8_SMBUS);
    public static final CrcModel CRC8_AUTOSAR = new CrcModel("CRC-8/AUTOSAR", 8, 47L, 255L, false, false, 255L, 223L);
    public static final CrcModel CRC8_BLUETOOTH = new CrcModel("CRC-8/BLUETOOTH", 8, 167L, 0L, true, true, 0L, 38L);
    public static final CrcModel CRC8_CDMA_2000 = new CrcModel("CRC-8/CDMA2000", 8, 155L, 255L, false, false, 0L, 218L);
    public static final CrcModel CRC8_DARC = new CrcModel("CRC-8/DARC", 8, 57L, 0L, true, true, 0L, 21L);
    public static final CrcModel CRC8_DVB_S2 = new CrcModel("CRC-8/DVB-S2", 8, 213L, 0L, false, false, 0L, 188L);
    public static final CrcModel CRC8_TECH_3250 = new CrcModel("CRC-8/TECH-3250", 8, 29L, 255L, true, true, 0L, 151L);
    public static final CrcModel CRC8_AES = CrcModel.alias("CRC-8/AES", CRC8_TECH_3250);
    public static final CrcModel CRC8_EBU = CrcModel.alias("CRC-8/EBU", CRC8_TECH_3250);
    public static final CrcModel CRC8_GSM_A = new CrcModel("CRC-8/GSM-A", 8, 29L, 0L, false, false, 0L, 55L);
    public static final CrcModel CRC8_GSM_B = new CrcModel("CRC-8/GSM-B", 8, 73L, 0L, false, false, 255L, 148L);
    public static final CrcModel CRC8_ICODE = new CrcModel("CRC-8/I-CODE", 8, 29L, 253L, false, false, 0L, 126L);
    public static final CrcModel CRC8_I_432_1 = new CrcModel("CRC-8/I-432-1", 8, 7L, 0L, false, false, 85L, 161L);
    public static final CrcModel CRC8_ITU = CrcModel.alias("CRC-8/ITU", CRC8_I_432_1);
    public static final CrcModel CRC8_LTE = new CrcModel("CRC-8/LTE", 8, 155L, 0L, false, false, 0L, 234L);
    public static final CrcModel CRC8_MAXIM_DOW = new CrcModel("CRC-8/MAXIM-DOW", 8, 49L, 0L, true, true, 0L, 161L);
    public static final CrcModel CRC8_MAXIM = CrcModel.alias("CRC-8/MAXIM", CRC8_MAXIM_DOW);
    public static final CrcModel DOW_CRC = CrcModel.alias("DOW-CRC", CRC8_MAXIM_DOW);
    public static final CrcModel CRC8_OPENSAFETY = new CrcModel("CRC-8/OPENSAFETY", 8, 47L, 0L, false, false, 0L, 62L);
    public static final CrcModel CRC8_ROHC = new CrcModel("CRC-8/ROHC", 8, 7L, 255L, true, true, 0L, 208L);
    public static final CrcModel CRC8_SAE_J1850 = new CrcModel("CRC-8/SAE-J1850", 8, 29L, 255L, false, false, 255L, 75L);
    public static final CrcModel CRC8_WCDMA = new CrcModel("CRC-8/WCDMA", 8, 155L, 0L, true, true, 0L, 37L);
    public static final CrcModel CRC10_ATM = new CrcModel("CRC-10/ATM", 10, 563L, 0L, false, false, 0L, 409L);
    public static final CrcModel CRC10_I_610 = CrcModel.alias("CRC-10/I-610", CRC10_ATM);
    public static final CrcModel CRC10 = CrcModel.alias("CRC-10", CRC10_ATM);
    public static final CrcModel CRC10_CDMA2000 = new CrcModel("CRC-10/CDMA2000", 10, 985L, 1023L, false, false, 0L, 563L);
    public static final CrcModel CRC10_GSM = new CrcModel("CRC-10/GSM", 10, 373L, 0L, false, false, 1023L, 298L);
    public static final CrcModel CRC11_FLEXRAY = new CrcModel("CRC-11/FLEXRAY", 11, 901L, 26L, false, false, 0L, 1443L);
    public static final CrcModel CRC11 = CrcModel.alias("CRC-11", CRC11_FLEXRAY);
    public static final CrcModel CRC11_UMTS = new CrcModel("CRC-11/UMTS", 11, 775L, 0L, false, false, 0L, 97L);
    public static final CrcModel CRC12_UMTS = new CrcModel("CRC-12/UMTS", 12, 2063L, 0L, false, true, 0L, 3503L);
    public static final CrcModel CRC12_3GPP = CrcModel.alias("CRC-12/3GPP", CRC12_UMTS);
    public static final CrcModel CRC12_CDMA2000 = new CrcModel("CRC-12/CDMA2000", 12, 3859L, 4095L, false, false, 0L, 3405L);
    public static final CrcModel CRC12_DECT = new CrcModel("CRC-12/DECT", 12, 2063L, 0L, false, false, 0L, 3931L);
    public static final CrcModel X_CRC_12 = CrcModel.alias("X-CRC-12", CRC12_DECT);
    public static final CrcModel CRC12_GSM = new CrcModel("CRC-12/GSM", 12, 3377L, 0L, false, false, 4095L, 2868L);
    public static final CrcModel CRC13_BBC = new CrcModel("CRC-13/BBC", 13, 7413L, 0L, false, false, 0L, 1274L);
    public static final CrcModel CRC14_DARC = new CrcModel("CRC-14/DARC", 14, 2053L, 0L, true, true, 0L, 2093L);
    public static final CrcModel CRC14_GSM = new CrcModel("CRC-14/GSM", 14, 8237L, 0L, false, false, 16383L, 12462L);
    public static final CrcModel CRC15_CAN = new CrcModel("CRC-15/CAN", 15, 17817L, 0L, false, false, 0L, 1438L);
    public static final CrcModel CRC15 = CrcModel.alias("CRC-15", CRC15_CAN);
    public static final CrcModel CRC15_MPT1327 = new CrcModel("CRC-15/MPT1327", 15, 26645L, 0L, false, false, 1L, 9574L);
    public static final CrcModel CRC16_ARC = new CrcModel("CRC-16/ARC", 16, 32773L, 0L, true, true, 0L, 47933L);
    public static final CrcModel ARC = CrcModel.alias("ARC", CRC16_ARC);
    public static final CrcModel CRC16 = CrcModel.alias("CRC-16", CRC16_ARC);
    public static final CrcModel CRC16_LHA = CrcModel.alias("CRC-16/LHA", CRC16_ARC);
    public static final CrcModel CRC_IBM = CrcModel.alias("CRC-IBM", CRC16_ARC);
    public static final CrcModel CRC16_SPI_FUJITSU = new CrcModel("CRC-16/SPI-FUJITSU", 16, 4129L, 7439L, false, false, 0L, 58828L);
    public static final CrcModel CRC16_AUG_CCITT = CrcModel.alias("CRC-16/AUG-CCITT", CRC16_SPI_FUJITSU);
    public static final CrcModel CRC16_UMTS = new CrcModel("CRC-16/UMTS", 16, 32773L, 0L, false, false, 0L, 65256L);
    public static final CrcModel CRC16_BUYPASS = CrcModel.alias("CRC-16/BUYPASS", CRC16_UMTS);
    public static final CrcModel CRC16_VERIFONE = CrcModel.alias("CRC-16/VERIFONE", CRC16_UMTS);
    public static final CrcModel CRC16_IBM_3740 = new CrcModel("CRC-16/IBM-3740", 16, 4129L, 65535L, false, false, 0L, 10673L);
    public static final CrcModel CRC16_AUTOSAR = CrcModel.alias("CRC-16/AUTOSAR", CRC16_IBM_3740);
    public static final CrcModel CRC16_CCITT_FALSE = CrcModel.alias("CRC-16/CCITT-FALSE", CRC16_IBM_3740);
    public static final CrcModel CRC16_CDMA2000 = new CrcModel("CRC-16/CDMA2000", 16, 51303L, 65535L, false, false, 0L, 19462L);
    public static final CrcModel CRC16_CMS = new CrcModel("CRC-16/CMS", 16, 32773L, 65535L, false, false, 0L, 44775L);
    public static final CrcModel CRC16_DDS_110 = new CrcModel("CRC-16/DDS-110", 16, 32773L, 32781L, false, false, 0L, 40655L);
    public static final CrcModel CRC16_DECT_R = new CrcModel("CRC-16/DECT-R", 16, 1417L, 0L, false, false, 1L, 126L);
    public static final CrcModel R_CRC_16 = CrcModel.alias("R-CRC-16", CRC16_DECT_R);
    public static final CrcModel CRC16_DECT_X = new CrcModel("CRC-16/DECT-X", 16, 1417L, 0L, false, false, 0L, 127L);
    public static final CrcModel X_CRC_16 = CrcModel.alias("X-CRC-16", CRC16_DECT_X);
    public static final CrcModel CRC16_DNP = new CrcModel("CRC-16/DNP", 16, 15717L, 0L, true, true, 65535L, 60034L);
    public static final CrcModel CRC16_EN13757 = new CrcModel("CRC-16/EN-13757", 16, 15717L, 0L, false, false, 65535L, 49847L);
    public static final CrcModel CRC16_GENIBUS = new CrcModel("CRC-16/GENIBUS", 16, 4129L, 65535L, false, false, 65535L, 54862L);
    public static final CrcModel CRC16_DARC = CrcModel.alias("CRC-16/DARC", CRC16_GENIBUS);
    public static final CrcModel CRC16_EPC = CrcModel.alias("CRC-16/EPC", CRC16_GENIBUS);
    public static final CrcModel CRC16_EPC_C1G2 = CrcModel.alias("CRC-16/EPC-C1G2", CRC16_GENIBUS);
    public static final CrcModel CRC16_I_CODE = CrcModel.alias("CRC-16/I-CODE", CRC16_GENIBUS);
    public static final CrcModel CRC16_GSM = new CrcModel("CRC-16/GSM", 16, 4129L, 0L, false, false, 65535L, 52796L);
    public static final CrcModel CRC16_KERMIT = new CrcModel("CRC-16/KERMIT", 16, 4129L, 0L, true, true, 0L, 8585L);
    public static final CrcModel CRC16_CCITT = CrcModel.alias("CRC-16/CCITT", CRC16_KERMIT);
    public static final CrcModel CRC16_CCITT_TRUE = CrcModel.alias("CRC-16/CCITT-TRUE", CRC16_KERMIT);
    public static final CrcModel CRC16_V_41_LSB = CrcModel.alias("CRC-16/V-41-LSB", CRC16_KERMIT);
    public static final CrcModel CRC_CCITT = CrcModel.alias("CRC-CCITT", CRC16_KERMIT);
    public static final CrcModel KERMIT = CrcModel.alias("KERMIT", CRC16_KERMIT);
    public static final CrcModel CRC16_LJ1200 = new CrcModel("CRC-16/LJ1200", 16, 28515L, 0L, false, false, 0L, 48628L);
    public static final CrcModel CRC16_MAXIM_DOW = new CrcModel("CRC-16/MAXIM-DOW", 16, 32773L, 0L, true, true, 65535L, 17602L);
    public static final CrcModel CRC16_MAXIM = CrcModel.alias("CRC-16/MAXIM", CRC16_MAXIM_DOW);
    public static final CrcModel CRC16_MCRF4XX = new CrcModel("CRC-16/MCRF4XX", 16, 4129L, 65535L, true, true, 0L, 28561L);
    public static final CrcModel CRC16_MODBUS = new CrcModel("CRC-16/MODBUS", 16, 32773L, 65535L, true, true, 0L, 19255L);
    public static final CrcModel MODBUS = CrcModel.alias("MODBUS", CRC16_MODBUS);
    public static final CrcModel CRC16_OPENSAFETY_A = new CrcModel("CRC-16/OPENSAFETY-A", 16, 22837L, 0L, false, false, 0L, 23864L);
    public static final CrcModel CRC16_OPENSAFETY_B = new CrcModel("CRC-16/OPENSAFETY-B", 16, 30043L, 0L, false, false, 0L, 8446L);
    public static final CrcModel CRC16_PROFIBUS = new CrcModel("CRC-16/PROFIBUS", 16, 7631L, 65535L, false, false, 65535L, 43033L);
    public static final CrcModel CRC16_IEC_61158_2 = CrcModel.alias("CRC-16/IEC-61158-2", CRC16_PROFIBUS);
    public static final CrcModel CRC16_RIELLO = new CrcModel("CRC-16/RIELLO", 16, 4129L, 45738L, true, true, 0L, 25552L);
    public static final CrcModel CRC16_T10_DIF = new CrcModel("CRC-16/T10-DIF", 16, 35767L, 0L, false, false, 0L, 53467L);
    public static final CrcModel CRC16_TELEDISK = new CrcModel("CRC-16/TELEDISK", 16, 41111L, 0L, false, false, 0L, 4019L);
    public static final CrcModel CRC16_TMS37157 = new CrcModel("CRC-16/TMS37157", 16, 4129L, 35308L, true, true, 0L, 9905L);
    public static final CrcModel CRC16_USB = new CrcModel("CRC-16/USB", 16, 32773L, 65535L, true, true, 65535L, 46280L);
    public static final CrcModel CRC16_ISO_IEC_14443_3_A = new CrcModel("CRC-16/ISO-IEC-14443-3-A", 16, 4129L, 50886L, true, true, 0L, 48901L);
    public static final CrcModel CRC_A = CrcModel.alias("CRC-A", CRC16_ISO_IEC_14443_3_A);
    public static final CrcModel CRC16_XMODEM = new CrcModel("CRC-16/XMODEM", 16, 4129L, 0L, false, false, 0L, 12739L);
    public static final CrcModel CRC16_ACORN = CrcModel.alias("CRC-16/ACORN", CRC16_XMODEM);
    public static final CrcModel CRC16_LTE = CrcModel.alias("CRC-16/LTE", CRC16_XMODEM);
    public static final CrcModel CRC16_V_41_MSB = CrcModel.alias("CRC-16/V-41-MSB", CRC16_XMODEM);
    public static final CrcModel XMODEM = CrcModel.alias("XMODEM", CRC16_XMODEM);
    public static final CrcModel ZMODEM = CrcModel.alias("ZMODEM", CRC16_XMODEM);
    public static final CrcModel CRC16_IBM_SDLC = new CrcModel("CRC-16/IBM-SDLC", 16, 4129L, 65535L, true, true, 65535L, 36974L);
    public static final CrcModel CRC16_ISO_HDLC = CrcModel.alias("CRC-16/ISO-HDLC", CRC16_IBM_SDLC);
    public static final CrcModel CRC16_ISO_IEC_14443_3_B = CrcModel.alias("CRC-16/ISO-IEC-14443-3-B", CRC16_IBM_SDLC);
    public static final CrcModel CRC16_X_25 = CrcModel.alias("CRC-16/X-25", CRC16_IBM_SDLC);
    public static final CrcModel CRCB = CrcModel.alias("CRC-B", CRC16_IBM_SDLC);
    public static final CrcModel X_25 = CrcModel.alias("X-25", CRC16_IBM_SDLC);
    public static final CrcModel CRC17_CAN_FD = new CrcModel("CRC-17/CAN-FD", 17, 92251L, 0L, false, false, 0L, 20227L);
    public static final CrcModel CRC21_CAN_FD = new CrcModel("CRC-21/CAN-FD", 21, 1058969L, 0L, false, false, 0L, 972865L);
    public static final CrcModel CRC24_OPENPGP = new CrcModel("CRC-24/OPENPGP", 24, 8801531L, 11994318L, false, false, 0L, 2215682L);
    public static final CrcModel CRC24 = CrcModel.alias("CRC-24", CRC24_OPENPGP);
    public static final CrcModel CRC24_BLE = new CrcModel("CRC-24/BLE", 24, 1627L, 0x555555L, true, true, 0L, 12737110L);
    public static final CrcModel CRC24_FLEXRAY_A = new CrcModel("CRC-24/FLEXRAY-A", 24, 6122955L, 16702650L, false, false, 0L, 7961021L);
    public static final CrcModel CRC24_FLEXRAY_B = new CrcModel("CRC-24/FLEXRAY-B", 24, 6122955L, 11259375L, false, false, 0L, 2040760L);
    public static final CrcModel CRC24_INTERLAKEN = new CrcModel("CRC-24/INTERLAKEN", 24, 3312483L, 0xFFFFFFL, false, false, 0xFFFFFFL, 11858918L);
    public static final CrcModel CRC24_LTE_A = new CrcModel("CRC-24/LTE-A", 24, 8801531L, 0L, false, false, 0L, 13494019L);
    public static final CrcModel CRC24_LTE_B = new CrcModel("CRC-24/LTE-B", 24, 8388707L, 0L, false, false, 0L, 2355026L);
    public static final CrcModel CRC30_CDMA = new CrcModel("CRC-30/CDMA", 30, 540064199L, 0x3FFFFFFFL, false, false, 0x3FFFFFFFL, 79907519L);
    public static final CrcModel CRC31_PHILIPS = new CrcModel("CRC-31/PHILIPS", 31, 79764919L, Integer.MAX_VALUE, false, false, Integer.MAX_VALUE, 216654956L);
    public static final CrcModel CRC32_ISO_HDLC = new CrcModel("CRC-32/ISO-HDLC", 32, 79764919L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL, 3421780262L);
    public static final CrcModel CRC32 = CrcModel.alias("CRC-32", CRC32_ISO_HDLC);
    public static final CrcModel CRC32_ADCCP = CrcModel.alias("CRC-32/ADCCP", CRC32_ISO_HDLC);
    public static final CrcModel CRC32_V42 = CrcModel.alias("CRC-32/V-42", CRC32_ISO_HDLC);
    public static final CrcModel CRC32_XZ = CrcModel.alias("CRC-32/XZ", CRC32_ISO_HDLC);
    public static final CrcModel PKZIP = CrcModel.alias("PKZIP", CRC32_ISO_HDLC);
    public static final CrcModel CRC32_AUTOSAR = new CrcModel("CRC-32/AUTOSAR", 32, 4104977171L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL, 379048042L);
    public static final CrcModel CRC32_BZIP2 = new CrcModel("CRC-32/BZIP2", 32, 79764919L, 0xFFFFFFFFL, false, false, 0xFFFFFFFFL, 4236843288L);
    public static final CrcModel CRC32_AAL5 = CrcModel.alias("CRC-32/AAL5", CRC32_BZIP2);
    public static final CrcModel CRC32_DECT_B = CrcModel.alias("CRC-32/DECT-B", CRC32_BZIP2);
    public static final CrcModel B_CRC_32 = CrcModel.alias("B-CRC-32", CRC32_BZIP2);
    public static final CrcModel CRC32_ISCSI = new CrcModel("CRC-32/ISCSI", 32, 517762881L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL, 3808858755L);
    public static final CrcModel CRC32_BASE91_C = CrcModel.alias("CRC-32/BASE91-C", CRC32_ISCSI);
    public static final CrcModel CRC32_CASTAGNOLI = CrcModel.alias("CRC-32/CASTAGNOLI", CRC32_ISCSI);
    public static final CrcModel CRC32_INTERLAKEN = CrcModel.alias("CRC-32/INTERLAKEN", CRC32_ISCSI);
    public static final CrcModel CRC32_C = CrcModel.alias("CRC32_C ", CRC32_ISCSI);
    public static final CrcModel CRC32_BASE91_D = new CrcModel("CRC-32/BASE91-D", 32, 2821953579L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL, 2268157302L);
    public static final CrcModel CRC32_D = CrcModel.alias("CRC-32D", CRC32_BASE91_D);
    public static final CrcModel CRC32_JAMCRC = new CrcModel("CRC-32/JAMCRC", 32, 79764919L, 0xFFFFFFFFL, true, true, 0L, 873187033L);
    public static final CrcModel JAMCRC = CrcModel.alias("JAMCRC", CRC32_JAMCRC);
    public static final CrcModel CRC32_MPEG_2 = new CrcModel("CRC-32/MPEG-2", 32, 79764919L, 0xFFFFFFFFL, false, false, 0L, 58124007L);
    public static final CrcModel CRC32_CKSUM = new CrcModel("CRC-32/CKSUM", 32, 79764919L, 0L, false, false, 0xFFFFFFFFL, 1985902208L);
    public static final CrcModel CKSUM = CrcModel.alias("CKSUM", CRC32_CKSUM);
    public static final CrcModel CRC32_POSIX = CrcModel.alias("CRC-32/POSIX", CRC32_CKSUM);
    public static final CrcModel CRC32_AIXM = new CrcModel("CRC-32/AIXM", 32, 2168537515L, 0L, false, false, 0L, 806403967L);
    public static final CrcModel CRC32_Q = CrcModel.alias("CRC-32Q", CRC32_AIXM);
    public static final CrcModel CRC32_XFER = new CrcModel("CRC-32/XFER", 32, 175L, 0L, false, false, 0L, 3171672888L);
    public static final CrcModel XFER = CrcModel.alias("XFER", CRC32_XFER);
    public static final CrcModel CRC40_GSM = new CrcModel("CRC-40/GSM", 40, 75628553L, 0L, false, false, 0xFFFFFFFFFFL, 910907393606L);
    public static final CrcModel CRC64_GO_ISO = new CrcModel("CRC-64/GO-ISO", 64, 27L, -1L, true, true, -1L, -5113460487230320639L);
    public static final CrcModel CRC64_ECMA_182 = new CrcModel("CRC-64/ECMA-182", 64, 4823603603198064275L, 0L, false, false, 0L, 7800480153909949255L);
    public static final CrcModel CRC64 = CrcModel.alias("CRC-64", CRC64_ECMA_182);
    public static final CrcModel CRC64_WE = new CrcModel("CRC-64/WE", 64, 4823603603198064275L, -1L, false, false, -1L, 7128171145767219210L);
    public static final CrcModel CRC64_XZ = new CrcModel("CRC-64/XZ", 64, 4823603603198064275L, -1L, true, true, -1L, -7395533204333446662L);
    public static final CrcModel CRC64_GO_ECMA = CrcModel.alias("CRC-64/GO-ECMA", CRC64_XZ);

    private CrcModel(String name, int width, long poly, long init, boolean refin, boolean refot, long xorot, Long check) {
        this(name, new CrcDescription(width, poly, init, refin, refot, xorot), check);
    }

    private CrcModel(String name, CrcDescription model, Long check) {
        super(CrcModel._config(Objects.requireNonNull(model, "CRC_model_t::new - model is null")));
        this.name = name == null ? super.toString() : name;
        this.crcDescription = model;
        this.check = Optional.ofNullable(check).orElseGet(() -> new CrcModel(null, model, -1L).getCRC().update(CHECK_BUFF.getBytes()).getCrc());
    }

    @Override
    public long getPoly() {
        return this.crcDescription.getPoly();
    }

    @Override
    public long getInit() {
        return this.crcDescription.getInit();
    }

    @Override
    public boolean isRefot() {
        return this.crcDescription.isRefot();
    }

    @Override
    public CRC getCRC() {
        CRC result = new CRC(this);
        this._init();
        return result;
    }

    public CRC getCRC(byte[] buff, int offset, int len) {
        return this.getCRC().update(buff, offset, len);
    }

    public CRC getCRC(byte[] buff, int len) {
        return this.getCRC(buff, 0, len);
    }

    public CRC getCRC(byte[] buff) {
        return this.getCRC(buff, 0, buff == null ? 0 : buff.length);
    }

    @Override
    public CRC getCRC(long crc, int len) {
        CRC result = new CRC(this, crc, len);
        this._init();
        return result;
    }

    @Override
    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _init() {
        if (this.table_byte == null) {
            CrcDescription crcDescription = this.crcDescription;
            synchronized (crcDescription) {
                if (this.crcDescription.table_byte == null) {
                    this.crcDescription.table_byte = this._createBytewiseTable();
                }
                this.table_byte = this.crcDescription.table_byte;
            }
        }
    }

    private static CrcDescription _config(CrcDescription model) {
        return new CrcDescription(model.width, model.refin ? CrcModel.reflect(model.poly, model.width) : model.poly, (model.refot ? CrcModel.reflect(model.init, model.width) : model.init) ^ model.xorot, model.refin, model.refot ^ model.refin, model.xorot);
    }

    private long[] _createBytewiseTable() {
        long[] table = new long[256];
        for (int k = 0; k < table.length; ++k) {
            long crc = this.createBitwiseValue(k);
            if (this.refot) {
                crc = this.reflect(crc);
            }
            if (this.width < 8 && !this.refin) {
                crc <<= 8 - this.width;
            }
            table[k] = crc;
        }
        return table;
    }

    private long createBitwiseValue(int k) {
        long poly = this.poly;
        long crc = this.xorot;
        if (this.refot) {
            crc = this.reflect(crc);
        }
        if (this.refin) {
            crc &= CrcModel.widmask(this.width);
            crc ^= (long)k;
            for (int i = 0; i < 8; ++i) {
                crc = (crc & 1L) != 0L ? crc >>> 1 ^ poly : crc >>> 1;
            }
        } else if (this.width <= 8) {
            int shift = 8 - this.width;
            poly <<= shift;
            crc <<= shift;
            crc ^= (long)k;
            for (int i = 0; i < 8; ++i) {
                crc = (crc & 0x80L) != 0L ? crc << 1 ^ poly : crc << 1;
            }
            crc >>= shift;
            crc &= CrcModel.widmask(this.width);
        } else {
            long mask = 1L << this.width - 1;
            int shift = this.width - 8;
            crc ^= (long)k << shift;
            for (int i = 0; i < 8; ++i) {
                crc = (crc & mask) != 0L ? crc << 1 ^ poly : crc << 1;
            }
            crc &= CrcModel.widmask(this.width);
        }
        if (this.refot) {
            crc = this.reflect(crc);
        }
        return crc ^ this.xorot;
    }

    protected long crcBytewise(long crc, byte[] buf, int offset, int len) {
        if (buf == null) {
            return this.init;
        }
        if (this.refot) {
            crc = this.reflect(crc);
        }
        if (this.refin) {
            crc &= CrcModel.widmask(this.width);
            while (len-- > 0) {
                crc = crc >>> 8 ^ this.table_byte[(int)((crc ^ (long)buf[offset++]) & 0xFFL)];
            }
        } else if (this.width <= 8) {
            int shift = 8 - this.width;
            crc <<= shift;
            while (len-- > 0) {
                crc = this.table_byte[(int)(crc ^ (long)buf[offset++])];
            }
            crc >>>= shift;
        } else {
            int shift = this.width - 8;
            while (len-- > 0) {
                crc = crc << 8 ^ this.table_byte[(int)((crc >>> shift ^ (long)(buf[offset++] & 0xFF)) & 0xFFL)];
            }
            crc &= CrcModel.widmask(this.width);
        }
        if (this.refot) {
            crc = this.reflect(crc);
        }
        return crc;
    }

    public static Stream<CrcModel> getModels() {
        return CrcModel.getModels(null);
    }

    @Generated
    private static CrcModel castModel(Field field) {
        if (field != null && field.getType().equals(CrcModel.class)) {
            try {
                return (CrcModel)field.get(0);
            }
            catch (IllegalAccessException iaex) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stream<CrcModel> getModels(Predicate<? super CrcModel> filter) {
        List<CrcModel> list = models;
        synchronized (list) {
            return Stream.concat(Arrays.stream(CrcModel.class.getDeclaredFields()).map(CrcModel::castModel).filter(Objects::nonNull).map(CrcModel.class::cast), models.stream()).filter(filter == null ? m -> true : filter);
        }
    }

    public static CrcModel lookUp(String name) {
        return name == null ? null : (CrcModel)CrcModel.getModels(m -> name.equals(m.getName())).findFirst().orElse(null);
    }

    @Generated
    private static String modelNameFirst(CrcModel model, String name) {
        return (model.getName().equals(name) ? "a" : "b") + model.getName();
    }

    public static CrcModel construct(String name, CrcDescription crcDescription, Long value) {
        return CrcModel.getModels(m -> Optional.of(Objects.requireNonNull(crcDescription, "CrcModel::construct - crcDescription is null")).filter(CrcModel.class::isInstance).map(CrcModel.class::cast).map(CrcModel::getCrcDescription).orElse(crcDescription).equals(m.getCrcDescription())).min(Comparator.comparing(mdl -> CrcModel.modelNameFirst(mdl, name))).map(model -> name == null || model.getName().equals(name) ? model : CrcModel.registerModel(name, model.getCrcDescription(), model.getCheck())).orElseGet(() -> CrcModel.registerModel(name, crcDescription, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CrcModel registerModel(String name, CrcDescription crcDescription, Long checkValue) {
        CrcModel crcModel = new CrcModel(name, crcDescription, checkValue);
        List<CrcModel> list = models;
        synchronized (list) {
            models.add(crcModel);
        }
        return crcModel;
    }

    public static CrcModel construct(CrcDescription crcDescription, Long value) {
        return CrcModel.construct(null, crcDescription, value);
    }

    public static CrcModel construct(CrcDescription crcDescription) {
        return CrcModel.construct(crcDescription, null);
    }

    public static CrcModel construct(String name, CrcDescription crcDescription) {
        return CrcModel.construct(name, crcDescription, null);
    }

    @Generated
    private static CrcModel alias(String name, CrcModel model) {
        return new CrcModel(name, model.getCrcDescription(), model.getCheck());
    }

    protected final long reflect(long value) {
        return CrcModel.reflect(value, this.getWidth());
    }

    protected static long reflect(long value, int bits) {
        long mask = CrcModel.widmask(bits);
        long rmask = mask ^ 0xFFFFFFFFFFFFFFFFL;
        long prefix = value & rmask;
        long suffix = Long.reverse(value << 64 - bits);
        return prefix | suffix;
    }

    protected static long widmask(int width) {
        return (1L << width - 1) - 1L << 1 | 1L;
    }

    private static long gf2_matrix_times(long[] mat, long vec) {
        long sum = 0L;
        int i = 0;
        while (vec != 0L) {
            if ((vec & 1L) != 0L) {
                sum ^= mat[i];
            }
            vec >>>= 1;
            ++i;
        }
        return sum;
    }

    private static void gf2_matrix_square(long[] square, long[] mat, int width) {
        for (int n = 0; n < width; ++n) {
            square[n] = CrcModel.gf2_matrix_times(mat, mat[n]);
        }
    }

    protected static long crc_general_combine(long crc1, long crc2, int len2, int width, long init, long poly, long xorot, boolean reflect) {
        int n;
        long col;
        long[] even = new long[width];
        long[] odd = new long[width];
        if (reflect) {
            init = CrcModel.reflect(init, width);
            poly = CrcModel.reflect(poly, width);
        }
        if (len2 <= 0) {
            return crc1;
        }
        crc1 ^= init ^ xorot;
        if (reflect) {
            odd[0] = poly;
            col = 1L;
            for (n = 1; n < width; ++n) {
                odd[n] = col;
                col <<= 1;
            }
        } else {
            col = 2L;
            for (n = 0; n < width - 1; ++n) {
                odd[n] = col;
                col <<= 1;
            }
            odd[n] = poly;
        }
        CrcModel.gf2_matrix_square(even, odd, width);
        CrcModel.gf2_matrix_square(odd, even, width);
        do {
            CrcModel.gf2_matrix_square(even, odd, width);
            if ((len2 & 1) != 0) {
                crc1 = CrcModel.gf2_matrix_times(even, crc1);
            }
            if ((len2 >>>= 1) == 0) break;
            CrcModel.gf2_matrix_square(odd, even, width);
            if ((len2 & 1) == 0) continue;
            crc1 = CrcModel.gf2_matrix_times(odd, crc1);
        } while ((len2 >>>= 1) != 0);
        return crc1 ^= crc2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrcModel)) {
            return false;
        }
        CrcModel other = (CrcModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$check = this.getCheck();
        Long other$check = other.getCheck();
        if (this$check == null ? other$check != null : !((Object)this$check).equals(other$check)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        CrcDescription this$crcDescription = this.getCrcDescription();
        CrcDescription other$crcDescription = other.getCrcDescription();
        return !(this$crcDescription == null ? other$crcDescription != null : !((Object)this$crcDescription).equals(other$crcDescription));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CrcModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $check = this.getCheck();
        result = result * 59 + ($check == null ? 43 : ((Object)$check).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        CrcDescription $crcDescription = this.getCrcDescription();
        result = result * 59 + ($crcDescription == null ? 43 : ((Object)$crcDescription).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Long getCheck() {
        return this.check;
    }

    public CrcDescription getCrcDescription() {
        return this.crcDescription;
    }
}

