/*
 * Decompiled with CFR 0.152.
 */
package org.rx.util;

import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.rx.annotation.ErrorCode;
import org.rx.annotation.Mapping;
import org.rx.bean.FlagsEnum;
import org.rx.bean.Tuple;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Reflects;
import org.rx.core.Strings;
import org.rx.core.Sys;
import org.rx.exception.ApplicationException;
import org.rx.exception.InvalidException;
import org.rx.util.BeanMapConverter;
import org.rx.util.BeanMapException;
import org.rx.util.BeanMapFlag;
import org.rx.util.BeanMapNullValueStrategy;
import org.rx.util.Validator;
import org.rx.util.function.PredicateFunc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;

public class BeanMapper {
    private static final Logger log = LoggerFactory.getLogger(BeanMapper.class);
    public static final BeanMapper DEFAULT = new BeanMapper();
    static final Mapping[] empty = new Mapping[0];
    private final Map<Integer, MapConfig> config = new ConcurrentHashMap<Integer, MapConfig>();
    private final FlagsEnum<BeanMapFlag> flags = BeanMapFlag.LOG_ON_MISS_MAPPING.flags();

    public static Map<String, Object> convertFromObjectString(String str, boolean root) {
        String startFlag = root ? "(" : "{";
        String endFlag = root ? ")" : "}";
        int s = Strings.indexOf((CharSequence)str, (CharSequence)startFlag);
        if (s == -1) {
            return Collections.emptyMap();
        }
        int e = Strings.lastIndexOf((CharSequence)str, (CharSequence)endFlag);
        if (e == -1) {
            return Collections.emptyMap();
        }
        return Linq.from(Strings.split(str.substring(s + 1, e), ", ")).select(p -> {
            int i = Strings.indexOf((CharSequence)p, (CharSequence)"=");
            if (i == -1) {
                throw new InvalidException("Parse error {}", p);
            }
            String k = p.substring(0, i);
            String v = p.substring(i + 1);
            return Tuple.of(k, Strings.startsWith((CharSequence)v, (CharSequence)"{") ? BeanMapper.convertFromObjectString(v, false) : v);
        }).toMap(p -> (String)p.left, p -> p.right);
    }

    @ErrorCode
    public <T> T define(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Extends.require(type, type.isInterface());
        return Sys.proxy(type, (m, p) -> {
            boolean noreturn;
            if (Reflects.OBJECT_METHODS.contains(m)) {
                return p.fastInvokeSuper();
            }
            Object[] args = p.arguments;
            Object target = null;
            if (m.isDefault()) {
                target = Reflects.invokeDefaultMethod(m, p.getProxyObject(), args);
            }
            boolean bl = noreturn = m.getReturnType() == Void.TYPE;
            if (args.length >= 2) {
                MapConfig config = this.setMappings(args[0].getClass(), noreturn ? args[1].getClass() : m.getReturnType(), type, p.getProxyObject(), (Method)m);
                this.map(args[0], (Object)Extends.ifNull(target, args[1]), config.flags, (Method)m);
                return noreturn ? null : args[1];
            }
            if (args.length == 1) {
                if (noreturn) {
                    return null;
                }
                MapConfig config = this.setMappings(args[0].getClass(), m.getReturnType(), type, p.getProxyObject(), (Method)m);
                if (target == null) {
                    target = Reflects.newInstance(m.getReturnType());
                }
                return this.map(args[0], target, config.flags, (Method)m);
            }
            throw new ApplicationException(Extends.values(m.getName()));
        });
    }

    private MapConfig setMappings(Class<?> from, Class<?> to, Class<?> type, Object instance, Method method) {
        MapConfig config = this.getConfig(from, to);
        config.mappings.computeIfAbsent(method, k -> {
            try {
                Method defMethod = type.getDeclaredMethod("getFlags", new Class[0]);
                if (defMethod.isDefault()) {
                    config.flags = (FlagsEnum)Reflects.invokeDefaultMethod(defMethod, instance, new Object[0]);
                }
            }
            catch (Exception e) {
                log.warn("BeanMapper.setMappings {}", (Object)e.toString());
            }
            return (Mapping[])method.getAnnotationsByType(Mapping.class);
        });
        return config;
    }

    private MapConfig getConfig(Class<?> from, Class<?> to) {
        return this.config.computeIfAbsent(Objects.hash(from, to), k -> new MapConfig(BeanCopier.create((Class)from, (Class)to, (boolean)true)));
    }

    public <T> T map(Object source, Class<T> targetType) {
        return this.map(source, Reflects.newInstance(targetType));
    }

    public <T> T map(Object source, T target) {
        return this.map(source, target, null);
    }

    public <T> T map(Object source, T target, FlagsEnum<BeanMapFlag> flags) {
        return this.map(source, target, flags, null);
    }

    private <T> T map(@NonNull Object source, @NonNull T target, FlagsEnum<BeanMapFlag> flags, Method method) {
        Linq<String> missedProperties;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (flags == null) {
            flags = this.flags;
        }
        boolean skipNull = flags.has(new BeanMapFlag[]{BeanMapFlag.SKIP_NULL});
        Class<?> from = source.getClass();
        Class<?> to = target.getClass();
        Linq<Reflects.PropertyNode> toProperties = Reflects.getProperties(to);
        TreeSet<String> copiedNames = new TreeSet<String>();
        Map sourceMap = Extends.as(source, Map.class);
        if (sourceMap != null) {
            for (Map.Entry entry : sourceMap.entrySet()) {
                Object propertyName;
                Reflects.PropertyNode propertyNode;
                if (entry.getKey() == null || (propertyNode = toProperties.firstOrDefault(arg_0 -> BeanMapper.lambda$map$3((String)(propertyName = entry.getKey().toString()), arg_0))) == null) continue;
                copiedNames.add((String)propertyName);
                Method targetMethod = propertyNode.setter;
                Class<?> targetType2 = targetMethod.getParameterTypes()[0];
                Reflects.invokeMethod(targetMethod, target, Reflects.changeType(entry.getValue(), targetType2));
            }
        } else {
            MapConfig config = this.getConfig(from, to);
            Linq<Mapping> mappings = Linq.from(method != null ? config.mappings.getOrDefault(method, empty) : empty);
            config.copier.copy(source, target, (sourceValue, targetType, methodName) -> {
                String propertyName = Reflects.propertyName(methodName.toString());
                copiedNames.add(propertyName);
                for (Mapping mapping : mappings) {
                    if (!Strings.hashEquals(mapping.target(), propertyName)) continue;
                    sourceValue = this.processMapping(mapping, sourceValue, targetType, propertyName, source, target, skipNull, toProperties);
                    break;
                }
                return Reflects.changeType(sourceValue, targetType);
            });
            for (Mapping mapping : mappings.where(p -> !copiedNames.contains(p.target()))) {
                copiedNames.add(mapping.target());
                Reflects.PropertyNode propertyNode = toProperties.firstOrDefault(p -> Extends.eq(p.propertyName, mapping.target()));
                if (propertyNode == null) {
                    log.warn("Target property {} not found", (Object)mapping.target());
                    continue;
                }
                Method targetMethod = propertyNode.setter;
                Class<?> targetType3 = targetMethod.getParameterTypes()[0];
                Object sourceValue2 = this.processMapping(mapping, null, targetType3, mapping.target(), source, target, skipNull, toProperties);
                Reflects.invokeMethod(targetMethod, target, Reflects.changeType(sourceValue2, targetType3));
            }
        }
        boolean logOnFail = flags.has(new BeanMapFlag[]{BeanMapFlag.LOG_ON_MISS_MAPPING});
        boolean throwOnFail = flags.has(new BeanMapFlag[]{BeanMapFlag.THROW_ON_MISS_MAPPING});
        if ((logOnFail || throwOnFail) && (missedProperties = toProperties.select(p -> p.propertyName).except(copiedNames)).any()) {
            String failMsg = String.format("Map %s to %s missed properties: %s", from.getSimpleName(), to.getSimpleName(), String.join((CharSequence)", ", missedProperties));
            if (throwOnFail) {
                throw new BeanMapException(failMsg, missedProperties.toSet());
            }
            log.warn(failMsg);
        }
        if (flags.has(new BeanMapFlag[]{BeanMapFlag.VALIDATE_BEAN})) {
            Validator.validateBean(target);
        }
        return target;
    }

    private Object processMapping(Mapping mapping, Object sourceValue, Class<?> targetType, String propertyName, Object source, Object target, boolean skipNull, Linq<Reflects.PropertyNode> toProperties) {
        Reflects.PropertyNode propertyNode;
        if (mapping.ignore() || sourceValue == null && (skipNull || Extends.eq(mapping.nullValueStrategy(), BeanMapNullValueStrategy.Ignore))) {
            return Reflects.invokeMethod(toProperties.first((PredicateFunc<Reflects.PropertyNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processMapping$7(java.lang.String org.rx.core.Reflects$PropertyNode ), (Lorg/rx/core/Reflects$PropertyNode;)Z)((String)propertyName)).getter, target, new Object[0]);
        }
        if (sourceValue instanceof String) {
            String val = (String)sourceValue;
            if (mapping.trim()) {
                val = val.trim();
            }
            if (!Strings.isEmpty((CharSequence)mapping.format())) {
                val = String.format(mapping.format(), val);
            }
            sourceValue = val;
        }
        if (sourceValue == null && Extends.eq(mapping.nullValueStrategy(), BeanMapNullValueStrategy.SetToDefault)) {
            sourceValue = mapping.defaultValue();
        }
        if (mapping.converter() != BeanMapConverter.class) {
            sourceValue = ((BeanMapConverter)Reflects.newInstance(mapping.converter())).convert(sourceValue, targetType, propertyName);
        }
        if (!Strings.isEmpty((CharSequence)mapping.source()) && (propertyNode = Reflects.getProperties(source.getClass()).firstOrDefault(p -> Extends.eq(mapping.source(), p.propertyName))) != null) {
            sourceValue = Reflects.invokeMethod(propertyNode.getter, source, new Object[0]);
        }
        return sourceValue;
    }

    private BeanMapper() {
    }

    private static /* synthetic */ boolean lambda$processMapping$7(String propertyName, Reflects.PropertyNode p) throws Throwable {
        return Extends.eq(p.propertyName, propertyName);
    }

    private static /* synthetic */ boolean lambda$map$3(String propertyName, Reflects.PropertyNode p) throws Throwable {
        return Extends.eq(p.propertyName, propertyName);
    }

    private static class MapConfig {
        private final BeanCopier copier;
        private final ConcurrentHashMap<Method, Mapping[]> mappings = new ConcurrentHashMap();
        private FlagsEnum<BeanMapFlag> flags;

        public MapConfig(BeanCopier copier) {
            this.copier = copier;
        }
    }
}

