/*
 * Decompiled with CFR 0.152.
 */
package org.rx.util;

import lombok.NonNull;
import org.rx.util.function.Func;

public final class Lazy<T> {
    private Func<T> func;
    private volatile T value;

    public boolean isValueCreated() {
        return this.value != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() {
        if (this.value == null) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.value == null) {
                    this.value = this.func.invoke();
                    this.func = null;
                }
            }
        }
        return this.value;
    }

    public Lazy(@NonNull Func<T> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        this.func = func;
    }

    public Lazy() {
    }
}

