/*
 * Decompiled with CFR 0.152.
 */
package org.rx.util;

import io.netty.util.concurrent.FastThreadLocal;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.rx.bean.DateTime;
import org.rx.bean.Tuple;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.core.Strings;
import org.rx.exception.InvalidException;
import org.rx.exception.TraceHandler;
import org.rx.io.IOStream;
import org.rx.net.http.HttpClient;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Servlets
extends ServletRequestUtils {
    static final FastThreadLocal<Tuple<HttpServletRequest, HttpServletResponse>> CTX = new FastThreadLocal();

    public static void setRequest(HttpServletRequest request, HttpServletResponse response) {
        CTX.set(Tuple.of(request, response));
    }

    public static Tuple<HttpServletRequest, HttpServletResponse> currentRequest() {
        Tuple<HttpServletRequest, HttpServletResponse> tuple = (Tuple<HttpServletRequest, HttpServletResponse>)CTX.getIfExists();
        if (tuple == null) {
            ServletRequestAttributes ra = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            tuple = Tuple.of(ra.getRequest(), ra.getResponse());
        }
        return tuple;
    }

    public static String requestIp() {
        String[] ips;
        HttpServletRequest request = (HttpServletRequest)Servlets.currentRequest().left;
        String ip = request.getHeader("X-Forwarded-For");
        if (Strings.isBlank((CharSequence)ip)) {
            ip = request.getHeader("x-real-ip");
        }
        if (Strings.isBlank((CharSequence)ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (Strings.isBlank((CharSequence)ip)) {
            ip = request.getRemoteAddr();
        }
        if ((ips = Strings.split(ip, ",")).length > 1) {
            ip = ips[0];
        }
        return ip;
    }

    public static String requestIp(boolean throwOnEmpty) {
        try {
            return Servlets.requestIp();
        }
        catch (Throwable e) {
            if (throwOnEmpty) {
                throw InvalidException.sneaky(e);
            }
            TraceHandler.INSTANCE.log(e);
            return "0.0.0.0";
        }
    }

    public static void responseFile(IOStream stream) {
        Servlets.responseFile(stream, "application/octet-stream");
    }

    public static void responseFile(@NonNull IOStream stream, String contentType) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        HttpServletResponse response = (HttpServletResponse)Servlets.currentRequest().right;
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        response.setContentType(contentType);
        response.setContentLength((int)stream.getLength());
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", HttpClient.encodeUrl(stream.getName())));
        stream.read((OutputStream)response.getOutputStream());
    }

    public static void cacheResponse(int cacheSeconds, String contentType, InputStream in) {
        HttpServletResponse response = (HttpServletResponse)Servlets.currentRequest().right;
        response.setHeader("Cache-Control", String.format("max-age=%s", cacheSeconds));
        response.setHeader("Expires", new Date(DateTime.now().addSeconds(cacheSeconds).getTime()).toString());
        response.setContentType(contentType);
        if (in != null) {
            IOStream.copy(in, -1L, (OutputStream)response.getOutputStream());
        }
    }

    public static String getCookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        HttpServletRequest request = (HttpServletRequest)Servlets.currentRequest().left;
        return Extends.quietly(() -> {
            if (ArrayUtils.isEmpty((Object[])request.getCookies())) {
                return null;
            }
            return Linq.from(request.getCookies()).where(p -> p.getName().equals(name)).select(p -> HttpClient.decodeUrl(p.getValue())).firstOrDefault();
        });
    }

    public static void setCookie(String name, String value) {
        Servlets.setCookie(name, value, null);
    }

    public static void setCookie(@NonNull String name, String value, Date expire) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Cookie cookie = new Cookie(name, HttpClient.encodeUrl(value));
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        if (expire != null) {
            cookie.setMaxAge((int)new DateTime(expire).subtract(DateTime.now()).getTotalSeconds());
        }
        ((HttpServletResponse)Servlets.currentRequest().right).addCookie(cookie);
    }

    public static void deleteCookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Cookie cookie = new Cookie(name, null);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setMaxAge(0);
        ((HttpServletResponse)Servlets.currentRequest().right).addCookie(cookie);
    }
}

