/*
 * Decompiled with CFR 0.152.
 */
package org.rx.util;

import io.netty.util.internal.ThreadLocalRandom;
import org.rx.bean.DateTime;
import org.rx.core.RxConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Snowflake {
    private static final Logger log = LoggerFactory.getLogger(Snowflake.class);
    public static final Snowflake DEFAULT;
    private static final long START_STAMP;
    private static final short MACHINE_BIT = 10;
    private static final short SEQUENCE_BIT = 12;
    private static final long MAX_MACHINE_NUM = 1023L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final short MACHINE_LEFT = 12;
    private static final short TIMESTAMP_LEFT = 22;
    private static final short STEP_SIZE = 1024;
    private final long machineId;
    private long sequence;
    private long lastStamp = -1L;
    private long basicSequence;

    public static Snowflake nextInstance() {
        return new Snowflake(ThreadLocalRandom.current().nextInt(0, 1023));
    }

    public Snowflake(int machineId) {
        if ((long)machineId > 1023L || machineId < 0) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long curStamp = System.currentTimeMillis();
        if (curStamp < this.lastStamp) {
            return this.handleClockBackwards(curStamp);
        }
        if (curStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                curStamp = this.getNextMill();
            }
        } else {
            this.sequence = this.basicSequence;
        }
        this.lastStamp = curStamp;
        return curStamp - START_STAMP << 22 | this.machineId << 12 | this.sequence;
    }

    private long handleClockBackwards(long curStamp) {
        this.basicSequence += 1024L;
        if (this.basicSequence == 4096L) {
            this.basicSequence = 0L;
            curStamp = this.getNextMill();
        }
        this.sequence = this.basicSequence;
        this.lastStamp = curStamp;
        return curStamp - START_STAMP << 22 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = System.currentTimeMillis();
        while (mill <= this.lastStamp) {
            mill = System.currentTimeMillis();
        }
        return mill;
    }

    static {
        int m = Math.abs(RxConfig.INSTANCE.getIntId()) % 1023;
        DEFAULT = new Snowflake(m);
        log.info("Snowflake machineId={}", (Object)m);
        START_STAMP = DateTime.valueOf("2020-02-04 00:00:00").getTime();
    }
}

