/*
 * Decompiled with CFR 0.152.
 */
package org.rx.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.executable.ExecutableValidator;
import org.rx.annotation.ValidRegex;
import org.rx.core.Extends;
import org.rx.core.Linq;
import org.rx.util.ValidateException;
import org.rx.util.function.Func;

public class Validator {
    static final javax.validation.Validator DEFAULT = Validation.buildDefaultValidatorFactory().getValidator();

    private static javax.validation.Validator getValidator() {
        return DEFAULT;
    }

    public static void validateBean(Object bean) {
        Iterable beans = Extends.ifNull(Linq.asIterable(bean, false), Collections.singletonList(bean));
        javax.validation.Validator validator = Validator.getValidator();
        for (Object b : beans) {
            for (ConstraintViolation violation : validator.validate(b, new Class[0])) {
                Validator.doThrow((ConstraintViolation<Object>)violation);
            }
        }
    }

    private static void doThrow(ConstraintViolation<Object> violation) {
        String pn = violation.getPropertyPath().toString();
        String vm = violation.getMessage();
        throw new ValidateException(pn, vm, String.format("%s.%s %s", violation.getRootBeanClass().getSimpleName(), pn, vm));
    }

    public static <T> T validateConstructor(Constructor<?> member, Object[] parameterValues, Func<T> proceed) {
        ExecutableValidator executableValidator = Validator.getValidator().forExecutables();
        Set result = executableValidator.validateConstructorParameters(member, parameterValues, new Class[0]);
        for (ConstraintViolation violation : result) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
        if (proceed == null) {
            return null;
        }
        T instance = proceed.get();
        result = executableValidator.validateConstructorReturnValue(member, instance, new Class[0]);
        for (ConstraintViolation violation : result) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
        return instance;
    }

    public static void validateConstructor(Constructor<?> member, Object[] parameterValues, Object instance) {
        ExecutableValidator executableValidator = Validator.getValidator().forExecutables();
        Set result = executableValidator.validateConstructorParameters(member, parameterValues, new Class[0]);
        for (ConstraintViolation violation : result) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
        if (instance == null) {
            return;
        }
        result = executableValidator.validateConstructorReturnValue(member, instance, new Class[0]);
        for (ConstraintViolation violation : result) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
    }

    public static <T> T validateMethod(Method member, Object instance, Object[] parameterValues, Func<T> proceed) {
        ExecutableValidator executableValidator = Validator.getValidator().forExecutables();
        for (ConstraintViolation violation : executableValidator.validateParameters(instance, member, parameterValues, new Class[0])) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
        if (proceed == null) {
            return null;
        }
        T retVal = proceed.get();
        for (ConstraintViolation violation : executableValidator.validateReturnValue(instance, member, retVal, new Class[0])) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
        return retVal;
    }

    public static void validateMethod(Method member, Object instance, Object[] parameterValues, Object returnValue) {
        ExecutableValidator executableValidator = Validator.getValidator().forExecutables();
        for (ConstraintViolation violation : executableValidator.validateParameters(instance, member, parameterValues, new Class[0])) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
        for (ConstraintViolation violation : executableValidator.validateReturnValue(instance, member, returnValue, new Class[0])) {
            Validator.doThrow((ConstraintViolation<Object>)violation);
        }
    }

    public static class RegexValidator
    implements ConstraintValidator<ValidRegex, String> {
        private ValidRegex validRegex;

        public void initialize(ValidRegex validRegex) {
            this.validRegex = validRegex;
        }

        public boolean isValid(String s, ConstraintValidatorContext context) {
            if (s == null) {
                return true;
            }
            Pattern p = Pattern.compile(this.validRegex.value().getRegexp(), 2);
            return p.matcher(s).matches();
        }
    }
}

