/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.testing;

import com.fnproject.fn.runtime.EntryPoint;
import com.fnproject.fn.runtime.EventCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class FnTestingClassLoader
extends ClassLoader {
    private final List<String> sharedPrefixes;
    private final Map<String, Class<?>> loaded = new HashMap();

    public FnTestingClassLoader(ClassLoader parent, List<String> sharedPrefixes) {
        super(parent);
        this.sharedPrefixes = sharedPrefixes;
    }

    boolean isShared(String classOrPackageName) {
        for (String prefix : this.sharedPrefixes) {
            if (!("=" + classOrPackageName).equals(prefix) && !classOrPackageName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> definedClass = this.loaded.get(className);
        if (definedClass != null) {
            return definedClass;
        }
        Class<?> cls = null;
        if (this.isShared(className)) {
            cls = this.getParent().loadClass(className);
        }
        if (cls == null) {
            try {
                InputStream in = this.getResourceAsStream(className.replace('.', '/') + ".class");
                if (in == null) {
                    throw new ClassNotFoundException("Class not found :" + className);
                }
                byte[] clsBytes = IOUtils.toByteArray((InputStream)in);
                cls = this.defineClass(className, clsBytes, 0, clsBytes.length);
                this.resolveClass(cls);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className, e);
            }
        }
        this.loaded.put(className, cls);
        return cls;
    }

    public int run(Map<String, String> mutableEnv, EventCodec codec, PrintStream functionErr, String ... s) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this);
            Class<?> entryPoint_class = this.loadClass(EntryPoint.class.getName());
            Object entryPoint = entryPoint_class.newInstance();
            int n = (Integer)this.getMethodInClassLoader(entryPoint, "run", Map.class, EventCodec.class, PrintStream.class, String[].class).invoke(entryPoint, mutableEnv, codec, functionErr, s);
            return n;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Something broke in the reflective classloader", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private Method getMethodInClassLoader(Object target, String method, Class ... types) throws NoSuchMethodException {
        Class<?> targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        return targetClass.getMethod(method, types);
    }
}

