/*
 * Decompiled with CFR 0.152.
 */
package com.github.roookeee.datus.immutable;

import com.github.roookeee.datus.api.Mapper;
import com.github.roookeee.datus.functions.Fn1;
import com.github.roookeee.datus.immutable.ImmutableMapperImpl;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public final class ConstructorBuilder<In, Out> {
    private final Fn1<In, Out> constructor;

    ConstructorBuilder(Fn1<In, Out> constructor) {
        this.constructor = constructor;
    }

    public ConstructorBuilder<In, Out> process(BiFunction<? super In, ? super Out, ? extends Out> processor) {
        return new ConstructorBuilder<Object, Object>(in -> processor.apply((In)in, (Out)this.constructor.apply(in)));
    }

    public ConstructorBuilder<In, Out> spy(BiConsumer<? super In, ? super Out> consumer) {
        return new ConstructorBuilder<Object, Object>(in -> {
            Out result = this.constructor.apply(in);
            consumer.accept((In)in, (Out)result);
            return result;
        });
    }

    public Mapper<In, Out> build() {
        return new ImmutableMapperImpl<In, Out>(this.constructor);
    }
}

